/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.servicetalk.opentracing.inmemory.SingleLineValue;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultInMemorySpanContext
implements InMemorySpanContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInMemorySpanContext.class);
    private final String traceId;
    private final String spanId;
    @Nullable
    private final String parentSpanId;
    @Nullable
    private final Boolean sampled;

    public DefaultInMemorySpanContext(String traceId, String spanId, @Nullable String parentSpanId, @Nullable Boolean sampled) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
        this.sampled = sampled;
    }

    public Boolean isSampled() {
        return this.sampled;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        logger.debug("baggageItems() is not supported");
        return Collections.emptyMap().entrySet();
    }

    public String toSpanId() {
        return this.spanId;
    }

    public String toTraceId() {
        return this.traceId;
    }

    public String parentSpanId() {
        return this.parentSpanId;
    }

    public String toString() {
        return SingleLineValue.format(this.traceId, this.spanId, this.parentSpanId);
    }
}

