/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.servicetalk.opentracing.inmemory.AbstractInMemorySpanBuilder;
import io.servicetalk.opentracing.inmemory.AbstractInMemoryTracer;
import io.servicetalk.opentracing.inmemory.CopyOnWriteInMemorySpanEventListenerSet;
import io.servicetalk.opentracing.inmemory.DefaultInMemorySpanContext;
import io.servicetalk.opentracing.inmemory.SampledInMemorySpan;
import io.servicetalk.opentracing.inmemory.SamplingStrategies;
import io.servicetalk.opentracing.inmemory.UnsampledInMemorySpan;
import io.servicetalk.opentracing.inmemory.api.InMemoryReference;
import io.servicetalk.opentracing.inmemory.api.InMemoryScopeManager;
import io.servicetalk.opentracing.inmemory.api.InMemorySpan;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanBuilder;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanEventListener;
import io.servicetalk.opentracing.internal.HexUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultInMemoryTracer
extends AbstractInMemoryTracer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInMemoryTracer.class);
    private final InMemoryScopeManager scopeManager;
    private final BiFunction<String, Boolean, Boolean> sampler;
    private final InMemorySpanEventListener listeners;
    private final int maxTagSize;
    private final boolean persistLogs;
    private final boolean use128BitTraceId;

    private DefaultInMemoryTracer(InMemoryScopeManager scopeManager, BiFunction<String, Boolean, Boolean> sampler, InMemorySpanEventListener listeners, int maxTagSize, boolean persistLogs, boolean use128BitTraceId) {
        this.scopeManager = scopeManager;
        this.sampler = sampler;
        this.listeners = listeners;
        this.maxTagSize = maxTagSize;
        this.persistLogs = persistLogs;
        this.use128BitTraceId = use128BitTraceId;
    }

    public InMemoryScopeManager scopeManager() {
        return this.scopeManager;
    }

    @Nullable
    public InMemorySpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    public Scope activateSpan(Span span) {
        return this.scopeManager.activate(span);
    }

    public InMemorySpanBuilder buildSpan(String operationName) {
        return new DefaultInMemorySpanBuilder(operationName);
    }

    public void close() {
    }

    private InMemorySpanContext newSpanContext(String traceId, String spanId, @Nullable String parentSpanId, boolean sampled) {
        return new DefaultInMemorySpanContext(traceId, spanId, parentSpanId, sampled);
    }

    private static String nextId() {
        return HexUtils.hexBytesOfLong((long)ThreadLocalRandom.current().nextLong());
    }

    private boolean isSampled(String traceId, @Nullable Boolean requestedByCarrier) {
        try {
            return this.sampler.apply(traceId, requestedByCarrier);
        }
        catch (Throwable t) {
            logger.warn("Exception from sampler={}, default to not sampling", this.sampler, (Object)t);
            return false;
        }
    }

    private final class DefaultInMemorySpanBuilder
    extends AbstractInMemorySpanBuilder {
        DefaultInMemorySpanBuilder(String operationName) {
            super(operationName, DefaultInMemoryTracer.this.maxTagSize);
        }

        @Override
        InMemorySpan createSpan(String operationName, List<InMemoryReference> references, Map<String, Object> tags, int maxTagSize, boolean ignoreActiveSpan, long startTimestampMicros) {
            boolean sampled;
            String parentSpanIdHex;
            String spanIdHex;
            String traceIdHex;
            InMemorySpan span;
            InMemorySpanContext maybeParent = this.parent();
            if (maybeParent == null && !ignoreActiveSpan && (span = DefaultInMemoryTracer.this.scopeManager().activeSpan()) != null) {
                maybeParent = span.context();
            }
            if (maybeParent != null) {
                traceIdHex = maybeParent.toTraceId();
                spanIdHex = DefaultInMemoryTracer.nextId();
                parentSpanIdHex = maybeParent.toSpanId();
                sampled = DefaultInMemoryTracer.this.isSampled(traceIdHex, maybeParent.isSampled());
            } else {
                spanIdHex = DefaultInMemoryTracer.nextId();
                traceIdHex = DefaultInMemoryTracer.this.use128BitTraceId ? DefaultInMemoryTracer.nextId() + spanIdHex : spanIdHex;
                parentSpanIdHex = null;
                sampled = DefaultInMemoryTracer.this.isSampled(traceIdHex, null);
            }
            InMemorySpanContext context = DefaultInMemoryTracer.this.newSpanContext(traceIdHex, spanIdHex, parentSpanIdHex, sampled);
            if (sampled) {
                SampledInMemorySpan span2 = new SampledInMemorySpan(operationName, references, context, tags, maxTagSize, startTimestampMicros, DefaultInMemoryTracer.this.listeners, DefaultInMemoryTracer.this.persistLogs);
                span2.start();
                return span2;
            }
            return new UnsampledInMemorySpan(operationName, references, context);
        }
    }

    public static final class Builder {
        private final InMemoryScopeManager scopeManager;
        private final CopyOnWriteInMemorySpanEventListenerSet listeners = new CopyOnWriteInMemorySpanEventListenerSet();
        private BiFunction<String, Boolean, Boolean> sampler = SamplingStrategies.sampleUnlessFalse();
        private int maxTagSize = 16;
        private boolean persistLogs;
        private boolean use128BitTraceId;

        public Builder(InMemoryScopeManager scopeManager) {
            this.scopeManager = Objects.requireNonNull(scopeManager);
        }

        public Builder withSampler(Predicate<String> sampler) {
            Objects.requireNonNull(sampler);
            this.withSampler((String traceId, Boolean requested) -> requested != null ? requested.booleanValue() : sampler.test((String)traceId));
            return this;
        }

        public Builder withSampler(BiFunction<String, Boolean, Boolean> sampler) {
            this.sampler = Objects.requireNonNull(sampler);
            return this;
        }

        public Builder addListener(InMemorySpanEventListener listener) {
            this.listeners.add(Objects.requireNonNull(listener));
            return this;
        }

        public Builder withMaxTagSize(int maxTagSize) {
            if (maxTagSize < 0) {
                throw new IllegalArgumentException("maxTagSize must be >= 0");
            }
            this.maxTagSize = maxTagSize;
            return this;
        }

        public Builder persistLogs(boolean persistLogs) {
            this.persistLogs = persistLogs;
            return this;
        }

        public Builder use128BitTraceId(boolean use128BitTraceId) {
            this.use128BitTraceId = use128BitTraceId;
            return this;
        }

        public DefaultInMemoryTracer build() {
            return new DefaultInMemoryTracer(this.scopeManager, this.sampler, this.listeners, this.maxTagSize, this.persistLogs, this.use128BitTraceId);
        }
    }
}

