/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.servicetalk.opentracing.inmemory.AbstractInMemorySpan;
import io.servicetalk.opentracing.inmemory.DefaultInMemorySpanLog;
import io.servicetalk.opentracing.inmemory.api.InMemoryReference;
import io.servicetalk.opentracing.inmemory.api.InMemorySpan;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanEventListener;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SampledInMemorySpan
extends AbstractInMemorySpan {
    private static final Logger logger = LoggerFactory.getLogger(SampledInMemorySpan.class);
    private static final byte STATE_INIT = 0;
    private static final byte STATE_STARTED = 1;
    private static final byte STATE_FINISHED = 2;
    private final Map<String, Object> tags;
    private final int maxTagSize;
    private final long startEpochMicros;
    private final long startSystemNanos;
    private final InMemorySpanEventListener listeners;
    @Nullable
    private final List<InMemorySpanLog> logs;
    private byte state;

    SampledInMemorySpan(String operationName, List<InMemoryReference> references, InMemorySpanContext context, @Nullable Map<String, Object> tags, int maxTagSize, long startEpochMicros, InMemorySpanEventListener listeners, boolean persistLogs) {
        super(operationName, references, context);
        this.tags = tags == null ? new HashMap<String, Object>(4) : new HashMap<String, Object>(tags);
        this.maxTagSize = maxTagSize;
        this.startEpochMicros = startEpochMicros;
        this.startSystemNanos = System.nanoTime();
        this.listeners = Objects.requireNonNull(listeners);
        this.logs = persistLogs ? new ArrayList(4) : null;
    }

    public Map<String, Object> tags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Nullable
    public List<InMemorySpanLog> logs() {
        return this.logs == null ? null : Collections.unmodifiableList(this.logs);
    }

    public Span setTag(String key, String value) {
        this.putTag(key, value);
        return this;
    }

    public Span setTag(String key, boolean value) {
        this.putTag(key, value);
        return this;
    }

    public Span setTag(String key, Number value) {
        this.putTag(key, value);
        return this;
    }

    public <T> Span setTag(Tag<T> tag, T value) {
        tag.set((Span)this, value);
        return this;
    }

    public Span log(Map<String, ?> fields) {
        return this.log(this.safeEpochMicros(), fields);
    }

    public Span log(long epochMicros, Map<String, ?> fields) {
        this.checkStarted();
        this.listeners.onEventLogged((InMemorySpan)this, epochMicros, fields);
        if (this.logs != null) {
            this.logs.add(new DefaultInMemorySpanLog(epochMicros, "key-value-event", fields));
        }
        return this;
    }

    public Span log(String event) {
        return this.log(this.safeEpochMicros(), event);
    }

    public Span log(long epochMicros, String event) {
        this.checkStarted();
        this.listeners.onEventLogged((InMemorySpan)this, epochMicros, event);
        if (this.logs != null) {
            this.logs.add(new DefaultInMemorySpanLog(epochMicros, event, null));
        }
        return this;
    }

    public long startEpochMicros() {
        return this.startEpochMicros;
    }

    public void finish() {
        if (this.state == 1) {
            this.notifyFinish((System.nanoTime() - this.startSystemNanos) / 1000L);
        } else {
            logger.warn("finish called invalid state={} on span={}", (Object)this.state, (Object)this);
        }
    }

    public void finish(long finishEpochMicros) {
        if (this.state == 1) {
            this.notifyFinish(finishEpochMicros - this.startEpochMicros);
        } else {
            logger.warn("finish called invalid state={} on span={}", (Object)this.state, (Object)this);
        }
    }

    void start() {
        if (this.state != 0) {
            throw new IllegalStateException("Span " + this + " in invalid state " + this.state);
        }
        this.state = 1;
        this.listeners.onSpanStarted((InMemorySpan)this);
    }

    private void checkStarted() {
        if (this.state != 1) {
            throw new IllegalStateException("Span " + this + " in invalid state " + this.state);
        }
    }

    private void putTag(String key, Object value) {
        if (this.tags.size() < this.maxTagSize) {
            this.tags.put(key, value);
        } else {
            logger.warn("Tag={} ignored since maxTagSize={} is reached", (Object)key, (Object)this.maxTagSize);
        }
    }

    private void notifyFinish(long durationMicros) {
        this.state = (byte)2;
        this.listeners.onSpanFinished((InMemorySpan)this, durationMicros);
    }

    private long safeEpochMicros() {
        return this.startEpochMicros + (System.nanoTime() - this.startSystemNanos) / 1000L;
    }
}

