/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.servicetalk.utils.internal.MathUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;

public final class SamplingStrategies {
    private SamplingStrategies() {
    }

    public static BiFunction<String, Boolean, Boolean> sampleUnlessFalse() {
        return (traceId, sampleRequested) -> sampleRequested == null || sampleRequested != false;
    }

    public static BiFunction<String, Boolean, Boolean> sampleRespectRequestOrEveryN(int sampleCountHint) {
        AtomicInteger sampleCount = new AtomicInteger();
        int sampleCountMask = MathUtils.safeFindNextPositivePowerOfTwo((int)sampleCountHint) - 1;
        return (traceId, sampleRequested) -> sampleRequested == null && (sampleCount.incrementAndGet() & sampleCountMask) == 0 || sampleRequested != null && sampleRequested != false;
    }

    public static BiFunction<String, Boolean, Boolean> sampleWhenRequestedOrEveryN(int sampleCountHint) {
        AtomicInteger sampleCount = new AtomicInteger();
        int sampleCountMask = MathUtils.safeFindNextPositivePowerOfTwo((int)sampleCountHint) - 1;
        return (traceId, sampleRequested) -> sampleRequested != null && sampleRequested != false || (sampleCount.incrementAndGet() & sampleCountMask) == 0;
    }
}

