/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.servicetalk.opentracing.inmemory.DefaultInMemorySpanContext;
import io.servicetalk.opentracing.inmemory.SingleLineValue;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContextFormat;
import io.servicetalk.opentracing.internal.HexUtils;
import javax.annotation.Nullable;

public final class SingleLineFormatter
implements InMemorySpanContextFormat<SingleLineValue> {
    public static final SingleLineFormatter INSTANCE = new SingleLineFormatter();

    private SingleLineFormatter() {
    }

    public void inject(InMemorySpanContext context, SingleLineValue carrier) {
        Boolean isSampled = context.isSampled();
        if (isSampled != null) {
            carrier.set(SingleLineValue.format(context.toTraceId(), context.toSpanId(), context.parentSpanId(), isSampled));
        } else {
            carrier.set(SingleLineValue.format(context.toTraceId(), context.toSpanId(), context.parentSpanId()));
        }
    }

    @Nullable
    public InMemorySpanContext extract(SingleLineValue carrier) {
        String parentSpanIdHex;
        String value = carrier.get();
        if (value == null) {
            return null;
        }
        int cursor = 0;
        int i1 = value.indexOf(46);
        String traceIdHex = (String)HexUtils.validateHexBytes((CharSequence)value.substring(cursor, i1));
        cursor = i1 + 1;
        int i2 = value.indexOf("<:", cursor);
        String spanIdHex = (String)HexUtils.validateHexBytes((CharSequence)value.substring(cursor, i2));
        cursor = i2 + 2;
        int i3 = value.indexOf(58, cursor);
        if (i3 < 0) {
            i3 = value.length();
        }
        String parentSpanIdResolved = "null".equals(parentSpanIdHex = value.substring(cursor, i3)) ? null : (String)HexUtils.validateHexBytes((CharSequence)parentSpanIdHex);
        Boolean sampled = null;
        if (i3 == value.length() - 2) {
            sampled = '1' == value.charAt(i3 + 1);
        }
        return new DefaultInMemorySpanContext(traceIdHex, spanIdHex, parentSpanIdResolved, sampled);
    }
}

