/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.servicetalk.opentracing.internal.HexUtils;
import io.servicetalk.opentracing.internal.TracingIdUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public interface SingleLineValue {
    @Nullable
    public String get();

    public void set(String var1);

    public static SingleLineValue of(final @Nullable String value) {
        return new SingleLineValue(){

            @Override
            @Nullable
            public String get() {
                return value;
            }

            @Override
            public void set(String value2) {
                throw new UnsupportedOperationException("Inject not supported");
            }
        };
    }

    public static SingleLineValue to(final Consumer<String> consumer) {
        return new SingleLineValue(){

            @Override
            @Nullable
            public String get() {
                throw new UnsupportedOperationException("Extract not supported");
            }

            @Override
            public void set(String value) {
                consumer.accept(value);
            }
        };
    }

    public static String format(long traceId, long spanId, @Nullable Long parentSpanId) {
        return SingleLineValue.format(HexUtils.hexBytesOfLong((long)traceId), HexUtils.hexBytesOfLong((long)spanId), parentSpanId == null ? null : HexUtils.hexBytesOfLong((long)parentSpanId));
    }

    public static String format(String traceIdHex, String spanIdHex, @Nullable String parentSpanIdHex) {
        return traceIdHex + '.' + spanIdHex + "<:" + TracingIdUtils.idOrNullAsValue((String)parentSpanIdHex);
    }

    public static String format(String traceIdHex, String spanIdHex, @Nullable String parentSpanIdHex, boolean isSampled) {
        return SingleLineValue.format(traceIdHex, spanIdHex, parentSpanIdHex) + (isSampled ? ":1" : ":0");
    }
}

