/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.inmemory;

import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import io.servicetalk.opentracing.inmemory.DefaultInMemorySpanContext;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContext;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContextExtractor;
import io.servicetalk.opentracing.inmemory.api.InMemorySpanContextInjector;
import io.servicetalk.opentracing.internal.HexUtils;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TextMapFormatter
implements InMemorySpanContextInjector<TextMapInject>,
InMemorySpanContextExtractor<TextMapExtract> {
    static final TextMapFormatter INSTANCE = new TextMapFormatter();
    private static final Logger logger = LoggerFactory.getLogger(TextMapFormatter.class);

    private TextMapFormatter() {
    }

    public void inject(InMemorySpanContext context, TextMapInject carrier) {
        Boolean isSampled;
        carrier.put("x-b3-traceid", context.toTraceId());
        carrier.put("x-b3-spanid", context.toSpanId());
        if (context.parentSpanId() != null) {
            carrier.put("x-b3-parentspanid", context.parentSpanId());
        }
        if ((isSampled = context.isSampled()) != null) {
            carrier.put("x-b3-sampled", isSampled != false ? "1" : "0");
        }
    }

    @Nullable
    public InMemorySpanContext extract(TextMapExtract carrier) {
        String traceId = null;
        String spanId = null;
        String parentSpanId = null;
        Boolean sampled = null;
        for (Map.Entry e : carrier) {
            String key = (String)e.getKey();
            String value = ((String)e.getValue()).trim();
            if ("x-b3-traceid".equalsIgnoreCase(key)) {
                if (value.isEmpty()) {
                    logger.warn("TraceId is empty");
                    continue;
                }
                traceId = (String)HexUtils.validateHexBytes((CharSequence)value);
                continue;
            }
            if ("x-b3-spanid".equalsIgnoreCase(key)) {
                if (value.isEmpty()) {
                    logger.warn("SpanId is empty");
                    continue;
                }
                spanId = (String)HexUtils.validateHexBytes((CharSequence)value);
                continue;
            }
            if ("x-b3-parentspanid".equalsIgnoreCase(key)) {
                if (value.isEmpty()) {
                    logger.warn("ParentSpanId is empty");
                    continue;
                }
                parentSpanId = (String)HexUtils.validateHexBytes((CharSequence)value);
                continue;
            }
            if (!"x-b3-sampled".equalsIgnoreCase(key)) continue;
            sampled = "1".equals(value);
        }
        if (traceId == null || spanId == null) {
            return null;
        }
        if (parentSpanId != null && parentSpanId.equals(spanId)) {
            logger.warn("SpanId cannot be the same as ParentSpanId, value={}", (Object)parentSpanId);
            return null;
        }
        return new DefaultInMemorySpanContext(traceId, spanId, parentSpanId, sampled);
    }
}

