/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.config;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Arrays;

public enum OrchestrationType {
    SHARDING("SHARDING"),
    MASTER_SLAVE("MASTER_SLAVE");

    private final String typeName;

    public static OrchestrationType valueFrom(final String typeName) {
        Optional typeOptional = Iterators.tryFind(Arrays.asList(OrchestrationType.values()).iterator(), (Predicate)new Predicate<OrchestrationType>(){

            public boolean apply(OrchestrationType input) {
                return input.typeName.equals(typeName.toUpperCase());
            }
        });
        if (typeOptional.isPresent()) {
            return (OrchestrationType)((Object)typeOptional.get());
        }
        throw new UnsupportedOperationException(String.format("Can not support orchestration type [%s].", typeName));
    }

    private OrchestrationType(String typeName) {
        this.typeName = typeName;
    }
}

