/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingsphere.jdbc.orchestration.config.OrchestrationConfiguration;
import io.shardingsphere.jdbc.orchestration.config.OrchestrationProxyConfiguration;
import io.shardingsphere.jdbc.orchestration.internal.config.ConfigurationService;
import io.shardingsphere.jdbc.orchestration.internal.listener.ListenerFactory;
import io.shardingsphere.jdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingsphere.jdbc.orchestration.internal.state.instance.InstanceStateService;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import io.shardingsphere.orchestration.reg.api.RegistryCenterConfiguration;
import io.shardingsphere.orchestration.reg.etcd.EtcdConfiguration;
import io.shardingsphere.orchestration.reg.etcd.EtcdRegistryCenter;
import io.shardingsphere.orchestration.reg.newzk.NewZookeeperRegistryCenter;
import io.shardingsphere.orchestration.reg.zookeeper.ZookeeperConfiguration;
import io.shardingsphere.orchestration.reg.zookeeper.ZookeeperRegistryCenter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrchestrationFacade
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(OrchestrationFacade.class);
    private final boolean isOverwrite;
    private final ConfigurationService configService;
    private final InstanceStateService instanceStateService;
    private final DataSourceService dataSourceService;
    private final ListenerFactory listenerManager;
    private final RegistryCenter regCenter;

    public OrchestrationFacade(OrchestrationConfiguration orchestrationConfig) {
        this.regCenter = this.createRegistryCenter(orchestrationConfig.getRegCenterConfig());
        this.isOverwrite = orchestrationConfig.isOverwrite();
        this.configService = new ConfigurationService(orchestrationConfig.getName(), this.regCenter);
        this.instanceStateService = new InstanceStateService(orchestrationConfig.getName(), this.regCenter);
        this.dataSourceService = new DataSourceService(orchestrationConfig.getName(), this.regCenter);
        this.listenerManager = new ListenerFactory(orchestrationConfig.getName(), this.regCenter);
    }

    private RegistryCenter createRegistryCenter(RegistryCenterConfiguration regCenterConfig) {
        Preconditions.checkNotNull((Object)regCenterConfig, (Object)"Registry center configuration cannot be null.");
        if (regCenterConfig instanceof ZookeeperConfiguration) {
            return this.getZookeeperRegistryCenter((ZookeeperConfiguration)regCenterConfig);
        }
        if (regCenterConfig instanceof EtcdConfiguration) {
            return new EtcdRegistryCenter((EtcdConfiguration)regCenterConfig);
        }
        throw new UnsupportedOperationException(regCenterConfig.getClass().getName());
    }

    private RegistryCenter getZookeeperRegistryCenter(ZookeeperConfiguration regCenterConfig) {
        if (regCenterConfig.isUseNative()) {
            return new NewZookeeperRegistryCenter(regCenterConfig);
        }
        return new ZookeeperRegistryCenter(regCenterConfig);
    }

    public void init(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props) {
        if (shardingRuleConfig.getMasterSlaveRuleConfigs().isEmpty()) {
            this.reviseShardingRuleConfigurationForMasterSlave(dataSourceMap, shardingRuleConfig);
        }
        this.configService.persistShardingConfiguration(this.getActualDataSourceMapForMasterSlave(dataSourceMap), shardingRuleConfig, configMap, props, this.isOverwrite);
        this.instanceStateService.persistShardingInstanceOnline();
        this.dataSourceService.persistDataSourcesNode();
        this.listenerManager.initShardingListeners();
    }

    public void init(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Map<String, Object> configMap, Properties props) {
        this.configService.persistMasterSlaveConfiguration(dataSourceMap, masterSlaveRuleConfig, configMap, props, this.isOverwrite);
        this.instanceStateService.persistMasterSlaveInstanceOnline();
        this.dataSourceService.persistDataSourcesNode();
        this.listenerManager.initMasterSlaveListeners();
    }

    public void init(OrchestrationProxyConfiguration orchestrationProxyConfiguration) {
        this.configService.persistProxyConfiguration(orchestrationProxyConfiguration, this.isOverwrite);
        this.instanceStateService.persistProxyInstanceOnline();
        this.dataSourceService.persistDataSourcesNode();
        this.listenerManager.initProxyListeners();
    }

    private void reviseShardingRuleConfigurationForMasterSlave(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig) {
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (!(entry.getValue() instanceof MasterSlaveDataSource)) continue;
            MasterSlaveDataSource masterSlaveDataSource = (MasterSlaveDataSource)entry.getValue();
            shardingRuleConfig.getMasterSlaveRuleConfigs().add(this.getMasterSlaveRuleConfiguration(masterSlaveDataSource));
        }
    }

    private Map<String, DataSource> getActualDataSourceMapForMasterSlave(Map<String, DataSource> dataSourceMap) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (entry.getValue() instanceof MasterSlaveDataSource) {
                MasterSlaveDataSource masterSlaveDataSource = (MasterSlaveDataSource)entry.getValue();
                result.putAll(masterSlaveDataSource.getAllDataSources());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private MasterSlaveRuleConfiguration getMasterSlaveRuleConfiguration(MasterSlaveDataSource masterSlaveDataSource) {
        return new MasterSlaveRuleConfiguration(masterSlaveDataSource.getMasterSlaveRule().getName(), masterSlaveDataSource.getMasterSlaveRule().getMasterDataSourceName(), masterSlaveDataSource.getMasterSlaveRule().getSlaveDataSourceNames(), masterSlaveDataSource.getMasterSlaveRule().getLoadBalanceAlgorithm());
    }

    @Override
    public void close() {
        try {
            this.regCenter.close();
        }
        catch (Exception ex) {
            log.warn("RegCenter exception for: {}", (Object)ex.getMessage());
        }
    }

    public ConfigurationService getConfigService() {
        return this.configService;
    }
}

