/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.config;

import io.shardingsphere.core.api.ConfigMapContext;
import io.shardingsphere.jdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingsphere.jdbc.orchestration.internal.config.ConfigurationService;
import io.shardingsphere.jdbc.orchestration.internal.listener.ListenerManager;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import io.shardingsphere.orchestration.reg.listener.DataChangedEvent;
import io.shardingsphere.orchestration.reg.listener.EventListener;

public final class ConfigMapListenerManager
implements ListenerManager {
    private final ConfigurationNode configNode;
    private final RegistryCenter regCenter;
    private final ConfigurationService configService;

    public ConfigMapListenerManager(String name, RegistryCenter regCenter) {
        this.configNode = new ConfigurationNode(name);
        this.regCenter = regCenter;
        this.configService = new ConfigurationService(name, regCenter);
    }

    @Override
    public void watchSharding() {
        String cachePath = this.configNode.getFullPath("config/sharding/configmap");
        this.regCenter.watch(cachePath, new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    ConfigMapContext.getInstance().getShardingConfig().clear();
                    ConfigMapContext.getInstance().getShardingConfig().putAll(ConfigMapListenerManager.this.configService.loadShardingConfigMap());
                }
            }
        });
    }

    @Override
    public void watchMasterSlave() {
        String cachePath = this.configNode.getFullPath("config/masterslave/configmap");
        this.regCenter.watch(cachePath, new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    ConfigMapContext.getInstance().getMasterSlaveConfig().clear();
                    ConfigMapContext.getInstance().getMasterSlaveConfig().putAll(ConfigMapListenerManager.this.configService.loadMasterSlaveConfigMap());
                }
            }
        });
    }

    @Override
    public void watchProxy() {
    }
}

