/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.config;

import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.jdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingsphere.jdbc.orchestration.internal.config.ConfigurationService;
import io.shardingsphere.jdbc.orchestration.internal.event.config.MasterSlaveConfigurationEventBusEvent;
import io.shardingsphere.jdbc.orchestration.internal.event.config.ProxyConfigurationEventBusEvent;
import io.shardingsphere.jdbc.orchestration.internal.event.config.ShardingConfigurationEventBusEvent;
import io.shardingsphere.jdbc.orchestration.internal.listener.ListenerManager;
import io.shardingsphere.jdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import io.shardingsphere.orchestration.reg.listener.DataChangedEvent;
import io.shardingsphere.orchestration.reg.listener.EventListener;
import java.util.Map;
import javax.sql.DataSource;

public final class ConfigurationListenerManager
implements ListenerManager {
    private final ConfigurationNode configNode;
    private final RegistryCenter regCenter;
    private final ConfigurationService configService;
    private final DataSourceService dataSourceService;

    public ConfigurationListenerManager(String name, RegistryCenter regCenter) {
        this.configNode = new ConfigurationNode(name);
        this.regCenter = regCenter;
        this.configService = new ConfigurationService(name, regCenter);
        this.dataSourceService = new DataSourceService(name, regCenter);
    }

    @Override
    public void watchSharding() {
        this.watchSharding("config/datasource");
        this.watchSharding("config/sharding/rule");
        this.watchSharding("config/sharding/props");
    }

    private void watchSharding(String node) {
        String cachePath = this.configNode.getFullPath(node);
        this.regCenter.watch(cachePath, new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    Map<String, DataSource> dataSourceMap = ConfigurationListenerManager.this.dataSourceService.getAvailableDataSources();
                    ShardingConfigurationEventBusEvent shardingEvent = new ShardingConfigurationEventBusEvent(dataSourceMap, new ShardingRule(ConfigurationListenerManager.this.dataSourceService.getAvailableShardingRuleConfiguration(), dataSourceMap.keySet()), ConfigurationListenerManager.this.configService.loadShardingProperties());
                    ShardingEventBusInstance.getInstance().post((Object)shardingEvent);
                }
            }
        });
    }

    @Override
    public void watchMasterSlave() {
        this.watchMasterSlave("config/datasource");
        this.watchMasterSlave("config/masterslave/rule");
        this.watchMasterSlave("config/masterslave/props");
    }

    private void watchMasterSlave(String node) {
        String cachePath = this.configNode.getFullPath(node);
        this.regCenter.watch(cachePath, new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    MasterSlaveConfigurationEventBusEvent masterSlaveEvent = new MasterSlaveConfigurationEventBusEvent(ConfigurationListenerManager.this.dataSourceService.getAvailableDataSources(), ConfigurationListenerManager.this.dataSourceService.getAvailableMasterSlaveRuleConfiguration(), ConfigurationListenerManager.this.configService.loadMasterSlaveProperties());
                    ShardingEventBusInstance.getInstance().post((Object)masterSlaveEvent);
                }
            }
        });
    }

    @Override
    public void watchProxy() {
        this.watchProxy("config/datasource");
        this.watchProxy("config/proxy/rule");
    }

    private void watchProxy(String node) {
        String cachePath = this.configNode.getFullPath(node);
        this.regCenter.watch(cachePath, new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    ShardingEventBusInstance.getInstance().post((Object)new ProxyConfigurationEventBusEvent(ConfigurationListenerManager.this.dataSourceService.getAvailableDataSourceParameters(), ConfigurationListenerManager.this.dataSourceService.getAvailableYamlProxyConfiguration()));
                }
            }
        });
    }
}

