/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.api.config.ProxyBasicRule;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.exception.ShardingConfigurationException;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.jdbc.orchestration.config.OrchestrationProxyConfiguration;
import io.shardingsphere.jdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingsphere.jdbc.orchestration.internal.yaml.converter.DataSourceConverter;
import io.shardingsphere.jdbc.orchestration.internal.yaml.converter.DataSourceParameterConverter;
import io.shardingsphere.jdbc.orchestration.internal.yaml.converter.MasterSlaveConfigurationConverter;
import io.shardingsphere.jdbc.orchestration.internal.yaml.converter.ProxyConfigurationConverter;
import io.shardingsphere.jdbc.orchestration.internal.yaml.converter.ShardingConfigurationConverter;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class ConfigurationService {
    private final ConfigurationNode configNode;
    private final RegistryCenter regCenter;

    public ConfigurationService(String name, RegistryCenter regCenter) {
        this.configNode = new ConfigurationNode(name);
        this.regCenter = regCenter;
    }

    public void persistShardingConfiguration(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props, boolean isOverwrite) {
        this.persistDataSourceConfiguration(dataSourceMap, isOverwrite);
        this.persistShardingRuleConfiguration(shardingRuleConfig, isOverwrite);
        this.persistShardingConfigMap(configMap, isOverwrite);
        this.persistShardingProperties(props, isOverwrite);
    }

    private void persistDataSourceConfiguration(Map<String, DataSource> dataSourceMap, boolean isOverwrite) {
        if (isOverwrite || !this.hasDataSourceConfiguration()) {
            Preconditions.checkState((null != dataSourceMap && !dataSourceMap.isEmpty() ? 1 : 0) != 0, (Object)"No available data source configuration for Orchestration.");
            this.regCenter.persist(this.configNode.getFullPath("config/datasource"), DataSourceConverter.dataSourceMapToYaml(dataSourceMap));
        }
    }

    private boolean hasDataSourceConfiguration() {
        return !Strings.isNullOrEmpty((String)this.regCenter.get(this.configNode.getFullPath("config/datasource")));
    }

    private void persistShardingRuleConfiguration(ShardingRuleConfiguration shardingRuleConfig, boolean isOverwrite) {
        if (isOverwrite || !this.hasShardingRuleConfiguration()) {
            Preconditions.checkState((null != shardingRuleConfig && !shardingRuleConfig.getTableRuleConfigs().isEmpty() ? 1 : 0) != 0, (Object)"No available sharding rule configuration for Orchestration.");
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/rule"), ShardingConfigurationConverter.shardingRuleConfigToYaml(shardingRuleConfig));
        }
    }

    private boolean hasShardingRuleConfiguration() {
        return !Strings.isNullOrEmpty((String)this.regCenter.get(this.configNode.getFullPath("config/sharding/rule")));
    }

    private void persistShardingConfigMap(Map<String, Object> configMap, boolean isOverwrite) {
        if (isOverwrite || !this.hasShardingConfigMap()) {
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/configmap"), ShardingConfigurationConverter.configMapToYaml(configMap));
        }
    }

    private boolean hasShardingConfigMap() {
        return !Strings.isNullOrEmpty((String)this.regCenter.get(this.configNode.getFullPath("config/sharding/configmap")));
    }

    private void persistShardingProperties(Properties props, boolean isOverwrite) {
        if (isOverwrite || !this.hasShardingProperties()) {
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/props"), ShardingConfigurationConverter.propertiesToYaml(props));
        }
    }

    private boolean hasShardingProperties() {
        return !Strings.isNullOrEmpty((String)this.regCenter.get(this.configNode.getFullPath("config/sharding/props")));
    }

    public void persistMasterSlaveConfiguration(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Map<String, Object> configMap, Properties props, boolean isOverwrite) {
        this.persistDataSourceConfiguration(dataSourceMap, isOverwrite);
        this.persistMasterSlaveRuleConfiguration(masterSlaveRuleConfig, isOverwrite);
        this.persistMasterSlaveConfigMap(configMap, isOverwrite);
        this.persistMasterSlaveProperties(props, isOverwrite);
    }

    private void persistMasterSlaveRuleConfiguration(MasterSlaveRuleConfiguration masterSlaveRuleConfig, boolean isOverwrite) {
        if (isOverwrite || !this.hasMasterSlaveRuleConfiguration()) {
            Preconditions.checkState((null != masterSlaveRuleConfig && !masterSlaveRuleConfig.getMasterDataSourceName().isEmpty() ? 1 : 0) != 0, (Object)"No available master slave configuration for Orchestration.");
            this.regCenter.persist(this.configNode.getFullPath("config/masterslave/rule"), MasterSlaveConfigurationConverter.masterSlaveRuleConfigToYaml(masterSlaveRuleConfig));
        }
    }

    private boolean hasMasterSlaveRuleConfiguration() {
        return !Strings.isNullOrEmpty((String)this.regCenter.get(this.configNode.getFullPath("config/masterslave/rule")));
    }

    private void persistMasterSlaveConfigMap(Map<String, Object> configMap, boolean isOverwrite) {
        if (isOverwrite || !this.hasMasterSlaveConfigMap()) {
            this.regCenter.persist(this.configNode.getFullPath("config/masterslave/configmap"), MasterSlaveConfigurationConverter.configMapToYaml(configMap));
        }
    }

    private boolean hasMasterSlaveConfigMap() {
        return !Strings.isNullOrEmpty((String)this.regCenter.get(this.configNode.getFullPath("config/masterslave/configmap")));
    }

    private void persistMasterSlaveProperties(Properties props, boolean isOverwrite) {
        if (isOverwrite || !this.hasMasterSlaveProperties()) {
            this.regCenter.persist(this.configNode.getFullPath("config/masterslave/props"), MasterSlaveConfigurationConverter.propertiesToYaml(props));
        }
    }

    private boolean hasMasterSlaveProperties() {
        return !Strings.isNullOrEmpty((String)this.regCenter.get(this.configNode.getFullPath("config/masterslave/props")));
    }

    public void persistProxyConfiguration(OrchestrationProxyConfiguration orchestrationProxyConfiguration, boolean isOverwrite) {
        this.persistDataSourceParameterConfiguration(orchestrationProxyConfiguration.getDataSources(), isOverwrite);
        this.persistProxyRuleConfiguration(orchestrationProxyConfiguration.getProxyBasicRule(), isOverwrite);
    }

    private void persistDataSourceParameterConfiguration(Map<String, DataSourceParameter> dataSourceParameterMap, boolean isOverwrite) {
        if (isOverwrite || !this.hasDataSourceConfiguration()) {
            Preconditions.checkState((null != dataSourceParameterMap && !dataSourceParameterMap.isEmpty() ? 1 : 0) != 0, (Object)"No available data source configuration for Orchestration.");
            this.regCenter.persist(this.configNode.getFullPath("config/datasource"), DataSourceParameterConverter.dataSourceParameterMapToYaml(dataSourceParameterMap));
        }
    }

    private boolean hasProxyConfig() {
        return !Strings.isNullOrEmpty((String)this.regCenter.get(this.configNode.getFullPath("config/proxy/rule")));
    }

    private void persistProxyRuleConfiguration(ProxyBasicRule proxyBasicRule, boolean isOverwrite) {
        if (isOverwrite || !this.hasProxyConfig()) {
            Preconditions.checkState((null != proxyBasicRule.getShardingRule() || null != proxyBasicRule.getMasterSlaveRule() ? 1 : 0) != 0, (Object)"No available proxy rule configuration for Orchestration.");
            this.regCenter.persist(this.configNode.getFullPath("config/proxy/rule"), ProxyConfigurationConverter.proxyConfigToYaml(proxyBasicRule));
        }
    }

    public Map<String, DataSource> loadDataSourceMap() {
        try {
            Map<String, DataSource> result = DataSourceConverter.dataSourceMapFromYaml(this.regCenter.getDirectly(this.configNode.getFullPath("config/datasource")));
            Preconditions.checkState((null != result && !result.isEmpty() ? 1 : 0) != 0, (Object)"No available data source configuration to load.");
            return result;
        }
        catch (Exception ex) {
            throw new ShardingConfigurationException("No available data source configuration to load.", new Object[0]);
        }
    }

    public Map<String, DataSourceParameter> loadDataSources() {
        try {
            Map<String, DataSourceParameter> result = DataSourceParameterConverter.dataSourceParameterMapFromYaml(this.regCenter.getDirectly(this.configNode.getFullPath("config/datasource")));
            Preconditions.checkState((null != result && !result.isEmpty() ? 1 : 0) != 0, (Object)"No available data source configuration to load.");
            return result;
        }
        catch (Exception ex) {
            throw new ShardingConfigurationException("No available data source configuration to load.", new Object[0]);
        }
    }

    public ShardingRuleConfiguration loadShardingRuleConfiguration() {
        try {
            ShardingRuleConfiguration result = ShardingConfigurationConverter.shardingRuleConfigFromYaml(this.regCenter.getDirectly(this.configNode.getFullPath("config/sharding/rule")));
            Preconditions.checkState((null != result && !result.getTableRuleConfigs().isEmpty() ? 1 : 0) != 0, (Object)"No available sharding rule configuration to load.");
            return result;
        }
        catch (Exception ex) {
            throw new ShardingConfigurationException("No available sharding rule configuration to load.", new Object[0]);
        }
    }

    public Map<String, Object> loadShardingConfigMap() {
        String data = this.regCenter.getDirectly(this.configNode.getFullPath("config/sharding/configmap"));
        return Strings.isNullOrEmpty((String)data) ? new HashMap() : ShardingConfigurationConverter.configMapFromYaml(data);
    }

    public Properties loadShardingProperties() {
        String data = this.regCenter.getDirectly(this.configNode.getFullPath("config/sharding/props"));
        return Strings.isNullOrEmpty((String)data) ? new Properties() : ShardingConfigurationConverter.propertiesFromYaml(data);
    }

    public MasterSlaveRuleConfiguration loadMasterSlaveRuleConfiguration() {
        try {
            MasterSlaveRuleConfiguration result = MasterSlaveConfigurationConverter.masterSlaveRuleConfigFromYaml(this.regCenter.getDirectly(this.configNode.getFullPath("config/masterslave/rule")));
            Preconditions.checkState((null != result && !Strings.isNullOrEmpty((String)result.getMasterDataSourceName()) ? 1 : 0) != 0, (Object)"No available master slave rule configuration to load.");
            return result;
        }
        catch (Exception ex) {
            throw new ShardingConfigurationException("No available master slave rule configuration to load.", new Object[0]);
        }
    }

    public Map<String, Object> loadMasterSlaveConfigMap() {
        String data = this.regCenter.getDirectly(this.configNode.getFullPath("config/masterslave/configmap"));
        return Strings.isNullOrEmpty((String)data) ? new LinkedHashMap() : MasterSlaveConfigurationConverter.configMapFromYaml(data);
    }

    public Properties loadMasterSlaveProperties() {
        String data = this.regCenter.getDirectly(this.configNode.getFullPath("config/masterslave/configmap"));
        return Strings.isNullOrEmpty((String)data) ? new Properties() : MasterSlaveConfigurationConverter.propertiesFromYaml(data);
    }

    public ProxyBasicRule loadProxyConfiguration() {
        try {
            ProxyBasicRule result = ProxyConfigurationConverter.proxyConfigFromYaml(this.regCenter.getDirectly(this.configNode.getFullPath("config/proxy/rule")));
            Preconditions.checkState((!Strings.isNullOrEmpty((String)result.getProxyAuthority().getUsername()) ? 1 : 0) != 0, (Object)"Authority configuration is invalid.");
            Preconditions.checkState((null != result.getShardingRule() || null != result.getMasterSlaveRule() ? 1 : 0) != 0, (Object)"Sharding rule or Master slave rule can not be both null.");
            return result;
        }
        catch (Exception ex) {
            throw new ShardingConfigurationException("No available proxy configuration to load.", new Object[0]);
        }
    }
}

