/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.listener;

import io.shardingsphere.jdbc.orchestration.internal.config.ConfigMapListenerManager;
import io.shardingsphere.jdbc.orchestration.internal.config.ConfigurationListenerManager;
import io.shardingsphere.jdbc.orchestration.internal.state.datasource.DataSourceListenerManager;
import io.shardingsphere.jdbc.orchestration.internal.state.instance.InstanceListenerManager;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;

public final class ListenerFactory {
    private final ConfigurationListenerManager configurationListenerManager;
    private final InstanceListenerManager instanceListenerManager;
    private final ConfigMapListenerManager configMapListenerManager;
    private final DataSourceListenerManager dataSourceListenerManager;

    public ListenerFactory(String name, RegistryCenter regCenter) {
        this.configurationListenerManager = new ConfigurationListenerManager(name, regCenter);
        this.instanceListenerManager = new InstanceListenerManager(name, regCenter);
        this.configMapListenerManager = new ConfigMapListenerManager(name, regCenter);
        this.dataSourceListenerManager = new DataSourceListenerManager(name, regCenter);
    }

    public void initShardingListeners() {
        this.configurationListenerManager.watchSharding();
        this.instanceListenerManager.watchSharding();
        this.dataSourceListenerManager.watchSharding();
        this.configMapListenerManager.watchSharding();
    }

    public void initMasterSlaveListeners() {
        this.configurationListenerManager.watchMasterSlave();
        this.instanceListenerManager.watchMasterSlave();
        this.dataSourceListenerManager.watchMasterSlave();
        this.configMapListenerManager.watchMasterSlave();
    }

    public void initProxyListeners() {
        this.configurationListenerManager.watchProxy();
        this.instanceListenerManager.watchProxy();
        this.dataSourceListenerManager.watchProxy();
        this.configMapListenerManager.watchProxy();
    }
}

