/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.state.datasource;

import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.jdbc.orchestration.internal.event.state.DisabledStateEventBusEvent;
import io.shardingsphere.jdbc.orchestration.internal.listener.ListenerManager;
import io.shardingsphere.jdbc.orchestration.internal.state.StateNode;
import io.shardingsphere.jdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import io.shardingsphere.orchestration.reg.listener.DataChangedEvent;
import io.shardingsphere.orchestration.reg.listener.EventListener;

public final class DataSourceListenerManager
implements ListenerManager {
    private final StateNode stateNode;
    private final RegistryCenter regCenter;
    private final DataSourceService dataSourceService;

    public DataSourceListenerManager(String name, RegistryCenter regCenter) {
        this.stateNode = new StateNode(name);
        this.regCenter = regCenter;
        this.dataSourceService = new DataSourceService(name, regCenter);
    }

    @Override
    public void watchSharding() {
        this.regCenter.watch(this.stateNode.getDataSourcesNodeFullPath(), new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType() || DataChangedEvent.Type.DELETED == event.getEventType()) {
                    ShardingEventBusInstance.getInstance().post((Object)new DisabledStateEventBusEvent(DataSourceListenerManager.this.dataSourceService.getDisabledDataSourceNames()));
                }
            }
        });
    }

    @Override
    public void watchMasterSlave() {
        this.regCenter.watch(this.stateNode.getDataSourcesNodeFullPath(), new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType() || DataChangedEvent.Type.DELETED == event.getEventType()) {
                    ShardingEventBusInstance.getInstance().post((Object)new DisabledStateEventBusEvent(DataSourceListenerManager.this.dataSourceService.getDisabledDataSourceNames()));
                }
            }
        });
    }

    @Override
    public void watchProxy() {
        this.regCenter.watch(this.stateNode.getDataSourcesNodeFullPath(), new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType() || DataChangedEvent.Type.DELETED == event.getEventType()) {
                    ShardingEventBusInstance.getInstance().post((Object)new DisabledStateEventBusEvent(DataSourceListenerManager.this.dataSourceService.getDisabledDataSourceNames()));
                }
            }
        });
    }
}

