/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.state.datasource;

import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.api.config.ProxyBasicRule;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.core.yaml.masterslave.YamlMasterSlaveRuleConfiguration;
import io.shardingsphere.jdbc.orchestration.internal.config.ConfigurationService;
import io.shardingsphere.jdbc.orchestration.internal.state.StateNode;
import io.shardingsphere.jdbc.orchestration.internal.state.StateNodeStatus;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public final class DataSourceService {
    private final StateNode stateNode;
    private final RegistryCenter regCenter;
    private final ConfigurationService configService;

    public DataSourceService(String name, RegistryCenter regCenter) {
        this.stateNode = new StateNode(name);
        this.regCenter = regCenter;
        this.configService = new ConfigurationService(name, regCenter);
    }

    public void persistDataSourcesNode() {
        this.regCenter.persist(this.stateNode.getDataSourcesNodeFullPath(), "");
    }

    public Map<String, DataSource> getAvailableDataSources() {
        Map<String, DataSource> result = this.configService.loadDataSourceMap();
        Collection<String> disabledDataSourceNames = this.getDisabledDataSourceNames();
        for (String each : disabledDataSourceNames) {
            result.remove(each);
        }
        return result;
    }

    public Map<String, DataSourceParameter> getAvailableDataSourceParameters() {
        Map<String, DataSourceParameter> result = this.configService.loadDataSources();
        Collection<String> disabledDataSourceNames = this.getDisabledDataSourceNames();
        for (String each : disabledDataSourceNames) {
            result.remove(each);
        }
        return result;
    }

    public ShardingRuleConfiguration getAvailableShardingRuleConfiguration() {
        ShardingRuleConfiguration result = this.configService.loadShardingRuleConfiguration();
        Collection<String> disabledDataSourceNames = this.getDisabledDataSourceNames();
        for (String each : disabledDataSourceNames) {
            for (MasterSlaveRuleConfiguration masterSlaveRuleConfig : result.getMasterSlaveRuleConfigs()) {
                masterSlaveRuleConfig.getSlaveDataSourceNames().remove(each);
            }
        }
        return result;
    }

    public MasterSlaveRuleConfiguration getAvailableMasterSlaveRuleConfiguration() {
        MasterSlaveRuleConfiguration result = this.configService.loadMasterSlaveRuleConfiguration();
        Collection<String> disabledDataSourceNames = this.getDisabledDataSourceNames();
        for (String each : disabledDataSourceNames) {
            result.getSlaveDataSourceNames().remove(each);
        }
        return result;
    }

    public ProxyBasicRule getAvailableYamlProxyConfiguration() {
        ProxyBasicRule result = this.configService.loadProxyConfiguration();
        Collection<String> disabledDataSourceNames = this.getDisabledDataSourceNames();
        for (String each : disabledDataSourceNames) {
            result.getMasterSlaveRule().getSlaveDataSourceNames().remove(each);
            this.removeDisabledDataSourceNames(each, result.getShardingRule().getMasterSlaveRules());
        }
        return result;
    }

    private void removeDisabledDataSourceNames(String disabledDataSourceName, Map<String, YamlMasterSlaveRuleConfiguration> masterSlaveRules) {
        for (Map.Entry<String, YamlMasterSlaveRuleConfiguration> each : masterSlaveRules.entrySet()) {
            each.getValue().getSlaveDataSourceNames().remove(disabledDataSourceName);
        }
    }

    public Collection<String> getDisabledDataSourceNames() {
        HashSet<String> result = new HashSet<String>();
        String dataSourcesNodePath = this.stateNode.getDataSourcesNodeFullPath();
        List dataSources = this.regCenter.getChildrenKeys(dataSourcesNodePath);
        for (String each : dataSources) {
            if (!StateNodeStatus.DISABLED.toString().equalsIgnoreCase(this.regCenter.get(dataSourcesNodePath + "/" + each))) continue;
            result.add(each);
        }
        return result;
    }
}

