/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.state.instance;

import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.jdbc.orchestration.internal.event.state.CircuitStateEventBusEvent;
import io.shardingsphere.jdbc.orchestration.internal.listener.ListenerManager;
import io.shardingsphere.jdbc.orchestration.internal.state.StateNode;
import io.shardingsphere.jdbc.orchestration.internal.state.StateNodeStatus;
import io.shardingsphere.jdbc.orchestration.internal.state.instance.OrchestrationInstance;
import io.shardingsphere.orchestration.reg.api.RegistryCenter;
import io.shardingsphere.orchestration.reg.listener.DataChangedEvent;
import io.shardingsphere.orchestration.reg.listener.EventListener;

public final class InstanceListenerManager
implements ListenerManager {
    private final StateNode stateNode;
    private final RegistryCenter regCenter;

    public InstanceListenerManager(String name, RegistryCenter regCenter) {
        this.stateNode = new StateNode(name);
        this.regCenter = regCenter;
    }

    @Override
    public void watchSharding() {
        this.regCenter.watch(this.stateNode.getInstancesNodeFullPath(OrchestrationInstance.getInstance().getInstanceId()), new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    if (StateNodeStatus.DISABLED.toString().equalsIgnoreCase(InstanceListenerManager.this.regCenter.get(event.getKey()))) {
                        ShardingEventBusInstance.getInstance().post((Object)new CircuitStateEventBusEvent(true));
                    } else {
                        ShardingEventBusInstance.getInstance().post((Object)new CircuitStateEventBusEvent(false));
                    }
                }
            }
        });
    }

    @Override
    public void watchMasterSlave() {
        this.regCenter.watch(this.stateNode.getInstancesNodeFullPath(OrchestrationInstance.getInstance().getInstanceId()), new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    if (StateNodeStatus.DISABLED.toString().equalsIgnoreCase(InstanceListenerManager.this.regCenter.get(event.getKey()))) {
                        ShardingEventBusInstance.getInstance().post((Object)new CircuitStateEventBusEvent(true));
                    } else {
                        ShardingEventBusInstance.getInstance().post((Object)new CircuitStateEventBusEvent(false));
                    }
                }
            }
        });
    }

    @Override
    public void watchProxy() {
        this.regCenter.watch(this.stateNode.getInstancesNodeFullPath(OrchestrationInstance.getInstance().getInstanceId()), new EventListener(){

            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    if (StateNodeStatus.DISABLED.toString().equalsIgnoreCase(InstanceListenerManager.this.regCenter.get(event.getKey()))) {
                        ShardingEventBusInstance.getInstance().post((Object)new CircuitStateEventBusEvent(true));
                    } else {
                        ShardingEventBusInstance.getInstance().post((Object)new CircuitStateEventBusEvent(false));
                    }
                }
            }
        });
    }
}

