/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.yaml.converter;

import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.yaml.sharding.YamlShardingRuleConfiguration;
import io.shardingsphere.jdbc.orchestration.internal.yaml.representer.DefaultConfigurationRepresenter;
import io.shardingsphere.jdbc.orchestration.internal.yaml.representer.ShardingConfigurationRepresenter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public final class ShardingConfigurationConverter {
    private static final Yaml YAML = new Yaml((Representer)new DefaultConfigurationRepresenter());

    public static String shardingRuleConfigToYaml(ShardingRuleConfiguration shardingRuleConfiguration) {
        Yaml yaml = new Yaml((Representer)new ShardingConfigurationRepresenter());
        YamlShardingRuleConfiguration yamlShardingRuleConfiguration = new YamlShardingRuleConfiguration(shardingRuleConfiguration, new HashMap(), new Properties());
        return yaml.dumpAsMap((Object)yamlShardingRuleConfiguration);
    }

    public static ShardingRuleConfiguration shardingRuleConfigFromYaml(String shardingRuleConfigYamlString) {
        return ((YamlShardingRuleConfiguration)YAML.loadAs(shardingRuleConfigYamlString, YamlShardingRuleConfiguration.class)).getShardingRuleConfiguration();
    }

    public static String configMapToYaml(Map<String, Object> configMap) {
        return YAML.dumpAsMap(configMap);
    }

    public static Map<String, Object> configMapFromYaml(String configMapYamlString) {
        return (Map)YAML.load(configMapYamlString);
    }

    public static String propertiesToYaml(Properties props) {
        return YAML.dumpAsMap((Object)props);
    }

    public static Properties propertiesFromYaml(String propertiesYamlString) {
        return (Properties)YAML.loadAs(propertiesYamlString, Properties.class);
    }

    private ShardingConfigurationConverter() {
    }
}

