/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.internal.yaml.representer;

import com.google.common.collect.Sets;
import io.shardingsphere.core.exception.ShardingException;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public final class DataSourceRepresenter
extends Representer {
    private static Collection<Class<?>> generalClassType = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class});
    private static Collection<String> eliminatedPropertyNames = Sets.newHashSet((Object[])new String[]{"loginTimeout"});
    private final Collection<String> propertyNames;

    public DataSourceRepresenter(Class<?> clazz) {
        this.nullRepresenter = new NullRepresent();
        this.propertyNames = this.getPropertyNames(clazz);
    }

    protected Set<Property> getProperties(Class<?> type) {
        Set propertySet;
        try {
            propertySet = super.getProperties(type);
        }
        catch (IntrospectionException ex) {
            throw new ShardingException((Exception)ex);
        }
        LinkedHashSet<Property> filteredSet = new LinkedHashSet<Property>();
        for (Property prop : propertySet) {
            String name = prop.getName();
            if (!this.propertyNames.contains(name)) continue;
            filteredSet.add(prop);
        }
        return filteredSet;
    }

    private Set<String> getPropertyNames(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        LinkedHashSet<String> getterMethodNames = new LinkedHashSet<String>();
        LinkedHashSet<String> setterMethodNames = new LinkedHashSet<String>();
        for (Method each : methods) {
            if (this.isGetterMethod(each)) {
                getterMethodNames.add(this.getPropertyName(each));
                continue;
            }
            if (!this.isSetterMethod(each)) continue;
            setterMethodNames.add(this.getPropertyName(each));
        }
        return this.getPairedGetterMethodNames(getterMethodNames, setterMethodNames);
    }

    private Set<String> getPairedGetterMethodNames(Set<String> getterMethodNames, Set<String> setterMethodNames) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String each : getterMethodNames) {
            if (!setterMethodNames.contains(each) || eliminatedPropertyNames.contains(each)) continue;
            result.add(each);
        }
        return result;
    }

    private String getPropertyName(Method method) {
        return String.valueOf(method.getName().charAt(3)).toLowerCase() + method.getName().substring(4, method.getName().length());
    }

    private boolean isGetterMethod(Method method) {
        return method.getName().startsWith("get") && 0 == method.getParameterTypes().length && this.isGeneralClassType(method.getReturnType());
    }

    private boolean isSetterMethod(Method method) {
        return method.getName().startsWith("set") && 1 == method.getParameterTypes().length && this.isGeneralClassType(method.getParameterTypes()[0]) && this.isVoid(method.getReturnType());
    }

    private boolean isGeneralClassType(Class<?> clazz) {
        return generalClassType.contains(clazz);
    }

    private boolean isVoid(Class<?> clazz) {
        return Void.TYPE == clazz || Void.class == clazz;
    }

    private class NullRepresent
    implements Represent {
        private NullRepresent() {
        }

        public Node representData(Object data) {
            return DataSourceRepresenter.this.representScalar(Tag.NULL, "");
        }
    }
}

