/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.orchestration.yaml;

import com.google.common.base.Preconditions;
import io.shardingsphere.jdbc.orchestration.config.OrchestrationConfiguration;
import io.shardingsphere.jdbc.orchestration.config.OrchestrationType;
import io.shardingsphere.orchestration.reg.api.RegistryCenterConfiguration;
import io.shardingsphere.orchestration.reg.etcd.EtcdConfiguration;
import io.shardingsphere.orchestration.reg.zookeeper.ZookeeperConfiguration;

public class YamlOrchestrationConfiguration {
    private String name;
    private EtcdConfiguration etcd;
    private ZookeeperConfiguration zookeeper;
    private boolean overwrite;
    private OrchestrationType type;

    public OrchestrationConfiguration getOrchestrationConfiguration() {
        Preconditions.checkState((null == this.etcd || null == this.zookeeper ? 1 : 0) != 0, (Object)"Can't config both zookeeper and etcd as registry center!");
        return new OrchestrationConfiguration(this.getName(), (RegistryCenterConfiguration)(null != this.etcd ? this.etcd : this.zookeeper), this.overwrite, this.type);
    }

    public String getName() {
        return this.name;
    }

    public EtcdConfiguration getEtcd() {
        return this.etcd;
    }

    public ZookeeperConfiguration getZookeeper() {
        return this.zookeeper;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public OrchestrationType getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEtcd(EtcdConfiguration etcd) {
        this.etcd = etcd;
    }

    public void setZookeeper(ZookeeperConfiguration zookeeper) {
        this.zookeeper = zookeeper;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setType(OrchestrationType type) {
        this.type = type;
    }
}

