/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy;

import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.core.yaml.YamlRuleConfiguration;
import io.shardingsphere.core.yaml.other.YamlServerConfiguration;
import io.shardingsphere.opentracing.ShardingTracer;
import io.shardingsphere.orchestration.internal.OrchestrationFacade;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.config.yaml.ProxyConfiguration;
import io.shardingsphere.shardingproxy.config.yaml.ProxyYamlConfigurationLoader;
import io.shardingsphere.shardingproxy.config.yaml.ProxyYamlRuleConfiguration;
import io.shardingsphere.shardingproxy.config.yaml.ProxyYamlServerConfiguration;
import io.shardingsphere.shardingproxy.frontend.ShardingProxy;
import io.shardingsphere.shardingproxy.listener.ProxyListenerRegister;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class Bootstrap {
    private static final int DEFAULT_PORT = 3307;

    public static void main(String[] args) throws InterruptedException, IOException {
        ProxyConfiguration proxyConfig = new ProxyYamlConfigurationLoader().load();
        int port = Bootstrap.getPort(args);
        new ProxyListenerRegister().register();
        if (null == proxyConfig.getServerConfiguration().getOrchestration()) {
            Bootstrap.startWithoutRegistryCenter(proxyConfig.getServerConfiguration(), proxyConfig.getRuleConfigurationMap(), port);
        } else {
            Bootstrap.startWithRegistryCenter(proxyConfig.getServerConfiguration(), proxyConfig.getRuleConfigurationMap(), port);
        }
    }

    private static int getPort(String[] args) {
        if (0 == args.length) {
            return 3307;
        }
        try {
            return Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            return 3307;
        }
    }

    private static void startWithoutRegistryCenter(ProxyYamlServerConfiguration serverConfig, Map<String, ProxyYamlRuleConfiguration> ruleConfigs, int port) throws InterruptedException {
        ProxyContext.getInstance().init(Bootstrap.getYamlServerConfiguration(serverConfig), Bootstrap.getSchemaDataSourceMap(ruleConfigs), Bootstrap.getRuleConfiguration(ruleConfigs));
        Bootstrap.initOpenTracing();
        new ShardingProxy().start(port);
    }

    private static void startWithRegistryCenter(ProxyYamlServerConfiguration serverConfig, Map<String, ProxyYamlRuleConfiguration> ruleConfigs, int port) throws InterruptedException {
        try (OrchestrationFacade orchestrationFacade = new OrchestrationFacade(serverConfig.getOrchestration().getOrchestrationConfiguration());){
            if (!ruleConfigs.isEmpty()) {
                orchestrationFacade.init(Bootstrap.getYamlServerConfiguration(serverConfig), Bootstrap.getSchemaDataSourceMap(ruleConfigs), Bootstrap.getRuleConfiguration(ruleConfigs));
            }
            ProxyContext.getInstance().init(orchestrationFacade.getConfigService().loadYamlServerConfiguration(), orchestrationFacade.getConfigService().loadProxyDataSources(), orchestrationFacade.getConfigService().loadProxyConfiguration());
            Bootstrap.initOpenTracing();
            new ShardingProxy().start(port);
        }
    }

    private static void initOpenTracing() {
        if (ProxyContext.getInstance().isOpenTracingEnable()) {
            ShardingTracer.init();
        }
    }

    private static YamlServerConfiguration getYamlServerConfiguration(ProxyYamlServerConfiguration serverConfig) {
        YamlServerConfiguration result = new YamlServerConfiguration();
        result.setProxyAuthority(serverConfig.getProxyAuthority());
        result.setProps(serverConfig.getProps());
        return result;
    }

    private static Map<String, Map<String, DataSourceParameter>> getSchemaDataSourceMap(Map<String, ProxyYamlRuleConfiguration> localRuleConfigs) {
        HashMap<String, Map<String, DataSourceParameter>> result = new HashMap<String, Map<String, DataSourceParameter>>(localRuleConfigs.size(), 1.0f);
        for (Map.Entry<String, ProxyYamlRuleConfiguration> entry : localRuleConfigs.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getDataSources());
        }
        return result;
    }

    private static Map<String, YamlRuleConfiguration> getRuleConfiguration(Map<String, ProxyYamlRuleConfiguration> localRuleConfigs) {
        HashMap<String, YamlRuleConfiguration> result = new HashMap<String, YamlRuleConfiguration>();
        for (Map.Entry<String, ProxyYamlRuleConfiguration> entry : localRuleConfigs.entrySet()) {
            YamlRuleConfiguration yamlRuleConfig = new YamlRuleConfiguration();
            yamlRuleConfig.setShardingRule(entry.getValue().getShardingRule());
            yamlRuleConfig.setMasterSlaveRule(entry.getValue().getMasterSlaveRule());
            result.put(entry.getKey(), yamlRuleConfig);
        }
        return result;
    }

    private Bootstrap() {
    }
}

