/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.UseStatement;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandler;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import java.sql.SQLException;

public abstract class AbstractBackendHandler
implements BackendHandler {
    private static final ProxyContext PROXY_CONTEXT = ProxyContext.getInstance();

    @Override
    public final CommandResponsePackets execute() {
        try {
            return this.execute0();
        }
        catch (Exception ex) {
            Optional<SQLException> sqlException = this.findSQLException(ex);
            return sqlException.isPresent() ? new CommandResponsePackets(new ErrPacket(1, (SQLException)sqlException.get())) : new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_STD_UNKNOWN_EXCEPTION, ex.getMessage()));
        }
    }

    protected abstract CommandResponsePackets execute0() throws Exception;

    private Optional<SQLException> findSQLException(Exception exception) {
        if (exception instanceof SQLException) {
            return Optional.of((Object)((SQLException)exception));
        }
        if (null == exception.getCause()) {
            return Optional.absent();
        }
        if (exception.getCause() instanceof SQLException) {
            return Optional.of((Object)((SQLException)exception.getCause()));
        }
        if (null == exception.getCause().getCause()) {
            return Optional.absent();
        }
        if (exception.getCause().getCause() instanceof SQLException) {
            return Optional.of((Object)((SQLException)exception.getCause().getCause()));
        }
        return Optional.absent();
    }

    protected final CommandResponsePackets handleUseStatement(UseStatement useStatement, FrontendHandler frontendHandler) {
        String schema = useStatement.getSchema();
        if (!PROXY_CONTEXT.schemaExists(schema)) {
            return new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_BAD_DB_ERROR, schema));
        }
        frontendHandler.setCurrentSchema(schema);
        return new CommandResponsePackets(new OKPacket(1));
    }
}

