/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.parsing.SQLJudgeEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.SetStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowColumnsStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowIndexStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowOtherStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTableStatusStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTablesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.UseStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.token.SchemaToken;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.jdbc.JDBCBackendHandler;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.JDBCExecuteEngine;
import io.shardingsphere.shardingproxy.backend.jdbc.wrapper.PreparedStatementExecutorWrapper;
import io.shardingsphere.shardingproxy.backend.jdbc.wrapper.StatementExecutorWrapper;
import io.shardingsphere.shardingproxy.backend.netty.NettyBackendHandler;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.config.RuleRegistry;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandler;
import java.util.LinkedList;
import java.util.List;

public final class BackendHandlerFactory {
    private static final ProxyContext PROXY_CONTEXT = ProxyContext.getInstance();

    public static BackendHandler newTextProtocolInstance(int connectionId, int sequenceId, String sql, BackendConnection backendConnection, DatabaseType databaseType, FrontendHandler frontendHandler) {
        Optional<String> schema = BackendHandlerFactory.getSchema(sql);
        RuleRegistry ruleRegistry = PROXY_CONTEXT.getRuleRegistry(schema.isPresent() ? (String)schema.get() : frontendHandler.getCurrentSchema());
        backendConnection.setRuleRegistry(ruleRegistry);
        return PROXY_CONTEXT.isUseNIO() ? new NettyBackendHandler(frontendHandler, ruleRegistry, connectionId, sequenceId, sql, databaseType) : new JDBCBackendHandler(frontendHandler, ruleRegistry, sql, new JDBCExecuteEngine(backendConnection, new StatementExecutorWrapper(ruleRegistry)));
    }

    public static BackendHandler newBinaryProtocolInstance(int connectionId, int sequenceId, String sql, List<Object> parameters, BackendConnection backendConnection, DatabaseType databaseType, FrontendHandler frontendHandler) {
        Optional<String> schema = BackendHandlerFactory.getSchema(sql);
        RuleRegistry ruleRegistry = PROXY_CONTEXT.getRuleRegistry(schema.isPresent() ? (String)schema.get() : frontendHandler.getCurrentSchema());
        backendConnection.setRuleRegistry(ruleRegistry);
        return PROXY_CONTEXT.isUseNIO() ? new NettyBackendHandler(frontendHandler, ruleRegistry, connectionId, sequenceId, sql, databaseType) : new JDBCBackendHandler(frontendHandler, ruleRegistry, sql, new JDBCExecuteEngine(backendConnection, new PreparedStatementExecutorWrapper(ruleRegistry, parameters)));
    }

    private static Optional<String> getSchema(String sql) {
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        if (SQLType.DCL == sqlStatement.getType() || sqlStatement instanceof SetStatement || sqlStatement instanceof ShowDatabasesStatement || sqlStatement instanceof ShowOtherStatement || sqlStatement instanceof UseStatement) {
            return Optional.of((Object)PROXY_CONTEXT.getDefaultSchema());
        }
        if (!sqlStatement.getSqlTokens().isEmpty() && (sqlStatement instanceof ShowTablesStatement || sqlStatement instanceof ShowColumnsStatement || sqlStatement instanceof ShowIndexStatement || sqlStatement instanceof ShowTableStatusStatement)) {
            LinkedList sqlTokens = new LinkedList();
            sqlTokens.addAll(sqlStatement.getSqlTokens());
            return Optional.of((Object)((SchemaToken)sqlTokens.getLast()).getSchemaName());
        }
        return Optional.absent();
    }

    private BackendHandlerFactory() {
    }
}

