/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.connection;

import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.routing.router.masterslave.MasterVisitedManager;
import io.shardingsphere.shardingproxy.config.RuleRegistry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class BackendConnection
implements AutoCloseable {
    private RuleRegistry ruleRegistry;
    private final Collection<Connection> cachedConnections = new CopyOnWriteArrayList<Connection>();
    private final Collection<Statement> cachedStatements = new CopyOnWriteArrayList<Statement>();
    private final Collection<ResultSet> cachedResultSets = new CopyOnWriteArrayList<ResultSet>();

    public int getConnectionSize() {
        return this.cachedConnections.size();
    }

    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        List<Connection> result = this.ruleRegistry.getBackendDataSource().getConnections(connectionMode, dataSourceName, connectionSize);
        this.cachedConnections.addAll(result);
        return result;
    }

    public void add(Statement statement) {
        this.cachedStatements.add(statement);
    }

    public void add(ResultSet resultSet) {
        this.cachedResultSets.add(resultSet);
    }

    public void cancel() {
        for (Statement each : this.cachedStatements) {
            try {
                each.cancel();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void close() throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        exceptions.addAll(this.closeResultSets());
        exceptions.addAll(this.closeStatements());
        exceptions.addAll(this.closeConnections());
        MasterVisitedManager.clear();
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    private Collection<SQLException> closeResultSets() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (ResultSet each : this.cachedResultSets) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    private Collection<SQLException> closeStatements() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Statement each : this.cachedStatements) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    private Collection<SQLException> closeConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.cachedConnections) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        throw ex;
    }

    public RuleRegistry getRuleRegistry() {
        return this.ruleRegistry;
    }

    public void setRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }
}

