/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.datasource;

import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.shardingproxy.backend.BackendDataSource;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCBackendDataSourceFactory;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCRawBackendDataSourceFactory;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCXABackendDataSourceFactory;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.config.RuleRegistry;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public final class JDBCBackendDataSource
implements BackendDataSource,
AutoCloseable {
    private final RuleRegistry ruleRegistry;
    private final Map<String, DataSource> dataSourceMap;

    public JDBCBackendDataSource(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
        this.dataSourceMap = this.createDataSourceMap();
    }

    private Map<String, DataSource> createDataSourceMap() {
        TransactionType transactionType = ProxyContext.getInstance().getTransactionType();
        Map<String, DataSourceParameter> dataSourceParameters = this.ruleRegistry.getDataSources();
        return this.getNormalDataSourceMap(transactionType, dataSourceParameters);
    }

    private Map<String, DataSource> getNormalDataSourceMap(TransactionType transactionType, Map<String, DataSourceParameter> dataSourceParameters) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSourceParameters.size());
        for (Map.Entry<String, DataSourceParameter> entry : dataSourceParameters.entrySet()) {
            try {
                result.put(entry.getKey(), this.getBackendDataSourceFactory(transactionType).build(entry.getKey(), entry.getValue()));
            }
            catch (Exception ex) {
                throw new ShardingException(String.format("Can not build data source, name is `%s`.", entry.getKey()), ex);
            }
        }
        return result;
    }

    private JDBCBackendDataSourceFactory getBackendDataSourceFactory(TransactionType transactionType) {
        switch (transactionType) {
            case XA: {
                return new JDBCXABackendDataSourceFactory();
            }
        }
        return new JDBCRawBackendDataSourceFactory();
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        return this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        DataSource dataSource = this.getDataSourceMap().get(dataSourceName);
        if (1 == connectionSize) {
            return Collections.singletonList(dataSource.getConnection());
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(dataSource, connectionSize);
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(dataSource, connectionSize);
        }
    }

    private Map<String, DataSource> getDataSourceMap() {
        return this.ruleRegistry.getDisabledDataSourceNames().isEmpty() ? this.dataSourceMap : this.getAvailableDataSourceMap();
    }

    private Map<String, DataSource> getAvailableDataSourceMap() {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(this.dataSourceMap);
        for (String each : this.ruleRegistry.getDisabledDataSourceNames()) {
            result.remove(each);
        }
        return result;
    }

    private List<Connection> createConnections(DataSource dataSource, int connectionSize) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            result.add(dataSource.getConnection());
        }
        return result;
    }

    @Override
    public void close() {
        this.closeOriginalDataSources();
    }

    private void closeOriginalDataSources() {
        for (DataSource each : this.dataSourceMap.values()) {
            try {
                Method method = each.getClass().getDeclaredMethod("close", new Class[0]);
                method.invoke((Object)each, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    public RuleRegistry getRuleRegistry() {
        return this.ruleRegistry;
    }
}

