/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCBackendDataSourceFactory;
import javax.sql.DataSource;

public final class JDBCRawBackendDataSourceFactory
implements JDBCBackendDataSourceFactory {
    private static final String DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";

    @Override
    public DataSource build(String dataSourceName, DataSourceParameter dataSourceParameter) {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(DRIVER_CLASS_NAME);
        config.setJdbcUrl(dataSourceParameter.getUrl());
        config.setUsername(dataSourceParameter.getUsername());
        config.setPassword(dataSourceParameter.getPassword());
        config.setAutoCommit(dataSourceParameter.isAutoCommit());
        config.setConnectionTimeout(dataSourceParameter.getConnectionTimeout());
        config.setIdleTimeout(dataSourceParameter.getIdleTimeout());
        config.setMaxLifetime(dataSourceParameter.getMaxLifetime());
        config.setMaximumPoolSize(dataSourceParameter.getMaximumPoolSize());
        config.addDataSourceProperty("useServerPrepStmts", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        config.addDataSourceProperty("useLocalSessionState", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("rewriteBatchedStatements", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cacheResultSetMetadata", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cacheServerConfiguration", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("elideSetAutoCommits", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("maintainTimeStats", (Object)Boolean.FALSE.toString());
        config.addDataSourceProperty("netTimeoutForStreamingResults", (Object)0);
        return new HikariDataSource(config);
    }
}

