/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.datasource;

import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCBackendDataSourceFactory;
import io.shardingsphere.transaction.manager.ShardingTransactionManagerRegistry;
import io.shardingsphere.transaction.manager.xa.XATransactionManager;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public final class JDBCXABackendDataSourceFactory
implements JDBCBackendDataSourceFactory {
    private static final String XA_DRIVER_CLASS_NAME = "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource";

    @Override
    public DataSource build(String dataSourceName, DataSourceParameter dataSourceParameter) throws Exception {
        XATransactionManager xaTransactionManager = (XATransactionManager)ShardingTransactionManagerRegistry.getInstance().getShardingTransactionManager(TransactionType.XA);
        Class xaDataSourceClass = this.loadClass(XA_DRIVER_CLASS_NAME);
        return xaTransactionManager.wrapDataSource((XADataSource)xaDataSourceClass.newInstance(), dataSourceName, dataSourceParameter);
    }

    private <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        Class<?> result;
        try {
            result = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            result = Class.forName(className);
        }
        return result;
    }
}

