/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.execute;

import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteTemplate;
import io.shardingsphere.core.executor.sql.execute.result.MemoryQueryResult;
import io.shardingsphere.core.executor.sql.execute.result.StreamQueryResult;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareCallback;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareTemplate;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.shardingproxy.backend.BackendExecutorContext;
import io.shardingsphere.shardingproxy.backend.SQLExecuteEngine;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.ExecuteQueryResponse;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.ExecuteResponse;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.ExecuteUpdateResponse;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.unit.ExecuteQueryResponseUnit;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.unit.ExecuteResponseUnit;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.response.unit.ExecuteUpdateResponseUnit;
import io.shardingsphere.shardingproxy.backend.jdbc.wrapper.JDBCExecutorWrapper;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.ColumnDefinition41Packet;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.FieldCountPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class JDBCExecuteEngine
implements SQLExecuteEngine {
    private static final Integer MEMORY_FETCH_ONE_ROW_A_TIME = Integer.MIN_VALUE;
    private final List<QueryResult> queryResults = new LinkedList<QueryResult>();
    private final BackendConnection backendConnection;
    private final JDBCExecutorWrapper jdbcExecutorWrapper;
    private int columnCount;
    private List<ColumnType> columnTypes;
    private final SQLExecutePrepareTemplate sqlExecutePrepareTemplate;
    private final SQLExecuteTemplate sqlExecuteTemplate;

    public JDBCExecuteEngine(BackendConnection backendConnection, JDBCExecutorWrapper jdbcExecutorWrapper) {
        this.backendConnection = backendConnection;
        this.jdbcExecutorWrapper = jdbcExecutorWrapper;
        int maxConnectionsSizePerQuery = ProxyContext.getInstance().getMaxConnectionsSizePerQuery();
        ShardingExecuteEngine executeEngine = BackendExecutorContext.getInstance().getExecuteEngine();
        this.sqlExecutePrepareTemplate = TransactionType.XA == ProxyContext.getInstance().getTransactionType() ? new SQLExecutePrepareTemplate(maxConnectionsSizePerQuery) : new SQLExecutePrepareTemplate(maxConnectionsSizePerQuery, executeEngine);
        this.sqlExecuteTemplate = new SQLExecuteTemplate(executeEngine);
    }

    @Override
    public ExecuteResponse execute(SQLRouteResult routeResult) throws SQLException {
        boolean isReturnGeneratedKeys = routeResult.getSqlStatement() instanceof InsertStatement;
        SQLType sqlType = routeResult.getSqlStatement().getType();
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        Collection sqlExecuteGroups = this.sqlExecutePrepareTemplate.getExecuteUnitGroups(routeResult.getRouteUnits(), (SQLExecutePrepareCallback)new ProxyJDBCExecutePrepareCallback(isReturnGeneratedKeys));
        List executeResponseUnits = this.sqlExecuteTemplate.executeGroup(sqlExecuteGroups, (SQLExecuteCallback)new FirstProxyJDBCExecuteCallback(sqlType, isExceptionThrown, isReturnGeneratedKeys), (SQLExecuteCallback)new ProxyJDBCExecuteCallback(sqlType, isExceptionThrown, isReturnGeneratedKeys));
        ExecuteResponseUnit firstExecuteResponseUnit = (ExecuteResponseUnit)executeResponseUnits.iterator().next();
        return firstExecuteResponseUnit instanceof ExecuteQueryResponseUnit ? this.getExecuteQueryResponse(((ExecuteQueryResponseUnit)firstExecuteResponseUnit).getQueryResponsePackets(), executeResponseUnits) : new ExecuteUpdateResponse(executeResponseUnits);
    }

    private ExecuteResponse getExecuteQueryResponse(QueryResponsePackets queryResponsePackets, Collection<ExecuteResponseUnit> executeResponseUnits) {
        ExecuteQueryResponse result = new ExecuteQueryResponse(queryResponsePackets);
        for (ExecuteResponseUnit each : executeResponseUnits) {
            result.getQueryResults().add(((ExecuteQueryResponseUnit)each).getQueryResult());
        }
        return result;
    }

    private ExecuteResponseUnit executeWithMetadata(Statement statement, String sql, ConnectionMode connectionMode, boolean isReturnGeneratedKeys) throws SQLException {
        this.backendConnection.add(statement);
        if (!this.jdbcExecutorWrapper.executeSQL(statement, sql, isReturnGeneratedKeys)) {
            return new ExecuteUpdateResponseUnit(new OKPacket(1, statement.getUpdateCount(), isReturnGeneratedKeys ? this.getGeneratedKey(statement) : 0L));
        }
        ResultSet resultSet = statement.getResultSet();
        this.backendConnection.add(resultSet);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (0 == resultSetMetaData.getColumnCount()) {
            return new ExecuteUpdateResponseUnit(new OKPacket(1));
        }
        return new ExecuteQueryResponseUnit(this.getHeaderPackets(resultSetMetaData), this.createQueryResult(resultSet, connectionMode));
    }

    private ExecuteResponseUnit executeWithoutMetadata(Statement statement, String sql, ConnectionMode connectionMode, boolean isReturnGeneratedKeys) throws SQLException {
        this.backendConnection.add(statement);
        if (!this.jdbcExecutorWrapper.executeSQL(statement, sql, isReturnGeneratedKeys)) {
            return new ExecuteUpdateResponseUnit(new OKPacket(1, statement.getUpdateCount(), isReturnGeneratedKeys ? this.getGeneratedKey(statement) : 0L));
        }
        ResultSet resultSet = statement.getResultSet();
        this.backendConnection.add(resultSet);
        return new ExecuteQueryResponseUnit(null, this.createQueryResult(resultSet, connectionMode));
    }

    private long getGeneratedKey(Statement statement) throws SQLException {
        ResultSet resultSet = statement.getGeneratedKeys();
        return resultSet.next() ? resultSet.getLong(1) : 0L;
    }

    private QueryResponsePackets getHeaderPackets(ResultSetMetaData resultSetMetaData) throws SQLException {
        int currentSequenceId = 0;
        int columnCount = resultSetMetaData.getColumnCount();
        FieldCountPacket fieldCountPacket = new FieldCountPacket(++currentSequenceId, columnCount);
        LinkedList<ColumnDefinition41Packet> columnDefinition41Packets = new LinkedList<ColumnDefinition41Packet>();
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            columnDefinition41Packets.add(new ColumnDefinition41Packet(++currentSequenceId, resultSetMetaData, columnIndex));
        }
        return new QueryResponsePackets(fieldCountPacket, columnDefinition41Packets, new EofPacket(++currentSequenceId));
    }

    private QueryResult createQueryResult(ResultSet resultSet, ConnectionMode connectionMode) throws SQLException {
        return connectionMode == ConnectionMode.MEMORY_STRICTLY ? new StreamQueryResult(resultSet) : new MemoryQueryResult(resultSet);
    }

    @ConstructorProperties(value={"backendConnection", "jdbcExecutorWrapper", "sqlExecutePrepareTemplate", "sqlExecuteTemplate"})
    public JDBCExecuteEngine(BackendConnection backendConnection, JDBCExecutorWrapper jdbcExecutorWrapper, SQLExecutePrepareTemplate sqlExecutePrepareTemplate, SQLExecuteTemplate sqlExecuteTemplate) {
        this.backendConnection = backendConnection;
        this.jdbcExecutorWrapper = jdbcExecutorWrapper;
        this.sqlExecutePrepareTemplate = sqlExecutePrepareTemplate;
        this.sqlExecuteTemplate = sqlExecuteTemplate;
    }

    public List<QueryResult> getQueryResults() {
        return this.queryResults;
    }

    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }

    public JDBCExecutorWrapper getJdbcExecutorWrapper() {
        return this.jdbcExecutorWrapper;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    public SQLExecutePrepareTemplate getSqlExecutePrepareTemplate() {
        return this.sqlExecutePrepareTemplate;
    }

    public SQLExecuteTemplate getSqlExecuteTemplate() {
        return this.sqlExecuteTemplate;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public void setColumnTypes(List<ColumnType> columnTypes) {
        this.columnTypes = columnTypes;
    }

    private final class ProxyJDBCExecuteCallback
    extends SQLExecuteCallback<ExecuteResponseUnit> {
        private final boolean isReturnGeneratedKeys;

        private ProxyJDBCExecuteCallback(SQLType sqlType, boolean isExceptionThrown, boolean isReturnGeneratedKeys) {
            super(DatabaseType.MySQL, sqlType, isExceptionThrown);
            this.isReturnGeneratedKeys = isReturnGeneratedKeys;
        }

        public ExecuteResponseUnit executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
            return JDBCExecuteEngine.this.executeWithoutMetadata(statementExecuteUnit.getStatement(), statementExecuteUnit.getRouteUnit().getSqlUnit().getSql(), statementExecuteUnit.getConnectionMode(), this.isReturnGeneratedKeys);
        }
    }

    private final class FirstProxyJDBCExecuteCallback
    extends SQLExecuteCallback<ExecuteResponseUnit> {
        private final boolean isReturnGeneratedKeys;
        private boolean hasMetaData;

        private FirstProxyJDBCExecuteCallback(SQLType sqlType, boolean isExceptionThrown, boolean isReturnGeneratedKeys) {
            super(DatabaseType.MySQL, sqlType, isExceptionThrown);
            this.isReturnGeneratedKeys = isReturnGeneratedKeys;
        }

        public ExecuteResponseUnit executeSQL(StatementExecuteUnit statementExecuteUnit) throws SQLException {
            if (this.hasMetaData) {
                return JDBCExecuteEngine.this.executeWithoutMetadata(statementExecuteUnit.getStatement(), statementExecuteUnit.getRouteUnit().getSqlUnit().getSql(), statementExecuteUnit.getConnectionMode(), this.isReturnGeneratedKeys);
            }
            this.hasMetaData = true;
            return JDBCExecuteEngine.this.executeWithMetadata(statementExecuteUnit.getStatement(), statementExecuteUnit.getRouteUnit().getSqlUnit().getSql(), statementExecuteUnit.getConnectionMode(), this.isReturnGeneratedKeys);
        }
    }

    private final class ProxyJDBCExecutePrepareCallback
    implements SQLExecutePrepareCallback {
        private final boolean isReturnGeneratedKeys;

        public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
            return JDBCExecuteEngine.this.getBackendConnection().getConnections(connectionMode, dataSourceName, connectionSize);
        }

        public StatementExecuteUnit createStatementExecuteUnit(Connection connection, RouteUnit routeUnit, ConnectionMode connectionMode) throws SQLException {
            Statement statement = JDBCExecuteEngine.this.getJdbcExecutorWrapper().createStatement(connection, routeUnit.getSqlUnit().getSql(), this.isReturnGeneratedKeys);
            if (connectionMode.equals((Object)ConnectionMode.MEMORY_STRICTLY)) {
                statement.setFetchSize(MEMORY_FETCH_ONE_ROW_A_TIME);
            }
            return new StatementExecuteUnit(routeUnit, statement, connectionMode);
        }

        @ConstructorProperties(value={"isReturnGeneratedKeys"})
        public ProxyJDBCExecutePrepareCallback(boolean isReturnGeneratedKeys) {
            this.isReturnGeneratedKeys = isReturnGeneratedKeys;
        }
    }
}

