/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.wrapper;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.SQLJudgeEngine;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.SQLUnit;
import io.shardingsphere.core.routing.StatementRoutingEngine;
import io.shardingsphere.core.routing.router.masterslave.MasterSlaveRouter;
import io.shardingsphere.shardingproxy.backend.jdbc.wrapper.JDBCExecutorWrapper;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.config.RuleRegistry;
import io.shardingsphere.shardingproxy.rewrite.MasterSlaveSQLRewriteEngine;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;

public final class StatementExecutorWrapper
implements JDBCExecutorWrapper {
    private static final ProxyContext PROXY_CONTEXT = ProxyContext.getInstance();
    private final RuleRegistry ruleRegistry;

    @Override
    public SQLRouteResult route(String sql, DatabaseType databaseType) {
        return this.ruleRegistry.isMasterSlaveOnly() ? this.doMasterSlaveRoute(sql) : this.doShardingRoute(sql, databaseType);
    }

    private SQLRouteResult doMasterSlaveRoute(String sql) {
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        String rewriteSQL = new MasterSlaveSQLRewriteEngine(this.ruleRegistry.getMasterSlaveRule(), sql, sqlStatement, this.ruleRegistry.getMetaData()).rewrite();
        SQLRouteResult result = new SQLRouteResult(sqlStatement);
        for (String each : new MasterSlaveRouter(this.ruleRegistry.getMasterSlaveRule(), PROXY_CONTEXT.isShowSQL()).route(rewriteSQL)) {
            result.getRouteUnits().add(new RouteUnit(each, new SQLUnit(rewriteSQL, Collections.emptyList())));
        }
        return result;
    }

    private SQLRouteResult doShardingRoute(String sql, DatabaseType databaseType) {
        StatementRoutingEngine routingEngine = new StatementRoutingEngine(this.ruleRegistry.getShardingRule(), this.ruleRegistry.getMetaData().getTable(), databaseType, PROXY_CONTEXT.isShowSQL(), this.ruleRegistry.getMetaData().getDataSource());
        return routingEngine.route(sql);
    }

    @Override
    public Statement createStatement(Connection connection, String sql, boolean isReturnGeneratedKeys) throws SQLException {
        return connection.createStatement();
    }

    @Override
    public boolean executeSQL(Statement statement, String sql, boolean isReturnGeneratedKeys) throws SQLException {
        return statement.execute(sql, isReturnGeneratedKeys ? 1 : 2);
    }

    @ConstructorProperties(value={"ruleRegistry"})
    public StatementExecutorWrapper(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }
}

