/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.client;

import io.shardingsphere.shardingproxy.backend.netty.client.BackendNettyClient;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import java.util.HashMap;
import java.util.Map;

public final class BackendNettyClientManager {
    private static final BackendNettyClientManager INSTANCE = new BackendNettyClientManager();
    private static final ProxyContext PROXY_CONTEXT = ProxyContext.getInstance();
    private final Map<String, BackendNettyClient> clientMap = new HashMap<String, BackendNettyClient>();

    public static BackendNettyClientManager getInstance() {
        return INSTANCE;
    }

    public BackendNettyClient getBackendNettyClient(String schema) {
        return this.clientMap.get(schema);
    }

    public void start() throws InterruptedException {
        for (String each : PROXY_CONTEXT.getSchemaNames()) {
            BackendNettyClient backendNettyClient = new BackendNettyClient(PROXY_CONTEXT.getRuleRegistry(each));
            this.clientMap.put(each, backendNettyClient);
            backendNettyClient.start();
        }
    }

    public void stop() {
        for (BackendNettyClient backendNettyClient : this.clientMap.values()) {
            backendNettyClient.stop();
        }
    }

    private BackendNettyClientManager() {
    }
}

