/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.client.response.mysql;

import com.google.common.collect.Lists;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.ColumnDefinition41Packet;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.FieldCountPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.TextResultSetRowPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLQueryResult
implements QueryResult {
    private static final Logger log = LoggerFactory.getLogger(MySQLQueryResult.class);
    private final CommandResponsePackets commandResponsePackets;
    private final int columnCount;
    private final Map<Integer, String> columnIndexAndLabelMap;
    private final Map<String, Integer> columnLabelAndIndexMap;
    private final List<ColumnDefinition41Packet> columnDefinitions;
    private final BlockingQueue<MySQLPacket> resultSet;
    private int currentSequenceId;
    private TextResultSetRowPacket currentRow;
    private boolean columnFinished;

    public MySQLQueryResult() {
        this.commandResponsePackets = new CommandResponsePackets();
        this.columnCount = 0;
        this.columnIndexAndLabelMap = null;
        this.columnLabelAndIndexMap = null;
        this.columnDefinitions = null;
        this.resultSet = null;
    }

    public MySQLQueryResult(MySQLPacketPayload payload) {
        FieldCountPacket fieldCountPacket = new FieldCountPacket(payload);
        this.commandResponsePackets = new CommandResponsePackets(fieldCountPacket);
        this.columnCount = fieldCountPacket.getColumnCount();
        this.columnIndexAndLabelMap = new HashMap<Integer, String>(fieldCountPacket.getColumnCount(), 1.0f);
        this.columnLabelAndIndexMap = new HashMap<String, Integer>(fieldCountPacket.getColumnCount(), 1.0f);
        this.columnDefinitions = Lists.newArrayListWithCapacity((int)fieldCountPacket.getColumnCount());
        this.currentSequenceId = fieldCountPacket.getSequenceId();
        this.resultSet = new LinkedBlockingQueue<MySQLPacket>();
    }

    public void setGenericResponse(MySQLPacket mysqlPacket) {
        this.commandResponsePackets.getPackets().add(mysqlPacket);
    }

    public boolean needColumnDefinition() {
        return this.columnCount > this.columnDefinitions.size();
    }

    public void addColumnDefinition(ColumnDefinition41Packet columnDefinition) {
        this.commandResponsePackets.getPackets().add(columnDefinition);
        this.columnDefinitions.add(columnDefinition);
        this.columnIndexAndLabelMap.put(this.columnDefinitions.indexOf(columnDefinition) + 1, columnDefinition.getName());
        this.columnLabelAndIndexMap.put(columnDefinition.getName(), this.columnDefinitions.indexOf(columnDefinition) + 1);
        ++this.currentSequenceId;
    }

    public void addTextResultSetRow(TextResultSetRowPacket textResultSetRow) {
        this.put(textResultSetRow);
    }

    public void setColumnFinished(EofPacket eofPacket) {
        this.commandResponsePackets.getPackets().add(eofPacket);
        ++this.currentSequenceId;
        this.columnFinished = true;
    }

    public void setRowFinished(EofPacket eofPacket) {
        this.put(eofPacket);
    }

    private void put(MySQLPacket mysqlPacket) {
        try {
            this.resultSet.put(mysqlPacket);
        }
        catch (InterruptedException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean next() {
        try {
            MySQLPacket mysqlPacket = this.resultSet.take();
            this.currentRow = mysqlPacket instanceof TextResultSetRowPacket ? (TextResultSetRowPacket)mysqlPacket : null;
            return null != this.currentRow;
        }
        catch (InterruptedException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnLabel(int columnIndex) {
        return this.columnIndexAndLabelMap.get(columnIndex);
    }

    public Object getValue(int columnIndex, Class<?> type) {
        return this.currentRow.getData().get(columnIndex - 1);
    }

    public Object getValue(String columnLabel, Class<?> type) {
        return this.currentRow.getData().get(this.columnLabelAndIndexMap.get(columnLabel));
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        return this.currentRow.getData().get(columnIndex - 1);
    }

    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) {
        return this.currentRow.getData().get(this.columnLabelAndIndexMap.get(columnLabel));
    }

    public InputStream getInputStream(int columnIndex, String type) {
        return (InputStream)this.currentRow.getData().get(columnIndex - 1);
    }

    public InputStream getInputStream(String columnLabel, String type) {
        return (InputStream)this.currentRow.getData().get(this.columnLabelAndIndexMap.get(columnLabel));
    }

    public boolean wasNull() {
        return false;
    }

    public CommandResponsePackets getCommandResponsePackets() {
        return this.commandResponsePackets;
    }

    public int getCurrentSequenceId() {
        return this.currentSequenceId;
    }

    public boolean isColumnFinished() {
        return this.columnFinished;
    }
}

