/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.client.response.mysql;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.shardingproxy.backend.netty.client.response.ResponseHandler;
import io.shardingsphere.shardingproxy.backend.netty.client.response.mysql.MySQLQueryResult;
import io.shardingsphere.shardingproxy.backend.netty.future.FutureRegistry;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.runtime.ChannelRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.constant.CapabilityFlag;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.ColumnDefinition41Packet;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.TextResultSetRowPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.HandshakePacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.HandshakeResponse41Packet;
import java.beans.ConstructorProperties;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLResponseHandler
extends ResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(MySQLResponseHandler.class);
    private static final ProxyContext PROXY_CONTEXT = ProxyContext.getInstance();
    private final DataSourceParameter dataSourceParameter;
    private final DataSourceMetaData dataSourceMetaData;
    private final Map<Integer, MySQLQueryResult> resultMap;

    public MySQLResponseHandler(String dataSourceName, String schema) {
        this.dataSourceParameter = PROXY_CONTEXT.getRuleRegistry(schema).getDataSources().get(dataSourceName);
        this.dataSourceMetaData = PROXY_CONTEXT.getRuleRegistry(schema).getMetaData().getDataSource().getActualDataSourceMetaData(dataSourceName);
        this.resultMap = new HashMap<Integer, MySQLQueryResult>();
    }

    @Override
    protected int getHeader(ByteBuf byteBuf) {
        MySQLPacketPayload payload = new MySQLPacketPayload(byteBuf);
        payload.getByteBuf().markReaderIndex();
        payload.readInt1();
        int result = payload.readInt1();
        payload.getByteBuf().resetReaderIndex();
        return result;
    }

    @Override
    protected void auth(ChannelHandlerContext context, ByteBuf byteBuf) {
        try (MySQLPacketPayload payload = new MySQLPacketPayload(byteBuf);){
            HandshakePacket handshakePacket = new HandshakePacket(payload);
            byte[] authResponse = this.securePasswordAuthentication((null == this.dataSourceParameter.getPassword() ? "" : this.dataSourceParameter.getPassword()).getBytes(), handshakePacket.getAuthPluginData().getAuthPluginData());
            HandshakeResponse41Packet handshakeResponse41Packet = new HandshakeResponse41Packet(handshakePacket.getSequenceId() + 1, CapabilityFlag.calculateHandshakeCapabilityFlagsLower(), 0xFFFFFF, 33, this.dataSourceParameter.getUsername(), authResponse, this.dataSourceMetaData.getSchemeName());
            ChannelRegistry.getInstance().putConnectionId(context.channel().id().asShortText(), handshakePacket.getConnectionId());
            context.writeAndFlush((Object)handshakeResponse41Packet);
        }
    }

    private byte[] securePasswordAuthentication(byte[] password, byte[] authPluginData) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] part1 = messageDigest.digest(password);
        messageDigest.reset();
        byte[] part2 = messageDigest.digest(part1);
        messageDigest.reset();
        messageDigest.update(authPluginData);
        byte[] result = messageDigest.digest(part2);
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(result[i] ^ part1[i]);
        }
        return result;
    }

    @Override
    protected void executeCommand(ChannelHandlerContext context, ByteBuf byteBuf, int header) {
        switch (header) {
            case 254: {
                this.eofPacket(context, byteBuf);
                break;
            }
            case 0: {
                this.okPacket(context, byteBuf);
                break;
            }
            case 255: {
                this.errPacket(context, byteBuf);
                break;
            }
            default: {
                this.commandPacket(context, byteBuf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okPacket(ChannelHandlerContext context, ByteBuf byteBuf) {
        int connectionId = ChannelRegistry.getInstance().getConnectionId(context.channel().id().asShortText());
        try (MySQLPacketPayload payload = new MySQLPacketPayload(byteBuf);){
            MySQLQueryResult mysqlQueryResult = new MySQLQueryResult();
            mysqlQueryResult.setGenericResponse(new OKPacket(payload));
            this.resultMap.put(connectionId, mysqlQueryResult);
            this.setResponse(context);
        }
        finally {
            this.resultMap.remove(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errPacket(ChannelHandlerContext context, ByteBuf byteBuf) {
        int connectionId = ChannelRegistry.getInstance().getConnectionId(context.channel().id().asShortText());
        try (MySQLPacketPayload payload = new MySQLPacketPayload(byteBuf);){
            MySQLQueryResult mysqlQueryResult = new MySQLQueryResult();
            mysqlQueryResult.setGenericResponse(new ErrPacket(payload));
            this.resultMap.put(connectionId, mysqlQueryResult);
            this.setResponse(context);
        }
        finally {
            this.resultMap.remove(connectionId);
        }
    }

    private void eofPacket(ChannelHandlerContext context, ByteBuf byteBuf) {
        int connectionId = ChannelRegistry.getInstance().getConnectionId(context.channel().id().asShortText());
        MySQLQueryResult mysqlQueryResult = this.resultMap.get(connectionId);
        MySQLPacketPayload payload = new MySQLPacketPayload(byteBuf);
        if (mysqlQueryResult.isColumnFinished()) {
            mysqlQueryResult.setRowFinished(new EofPacket(payload));
            this.resultMap.remove(connectionId);
            payload.close();
        } else {
            mysqlQueryResult.setColumnFinished(new EofPacket(payload));
            this.setResponse(context);
        }
    }

    private void setResponse(ChannelHandlerContext context) {
        int connectionId = ChannelRegistry.getInstance().getConnectionId(context.channel().id().asShortText());
        if (null != FutureRegistry.getInstance().get(connectionId)) {
            FutureRegistry.getInstance().get(connectionId).setResponse(this.resultMap.get(connectionId));
        }
    }

    private void commandPacket(ChannelHandlerContext context, ByteBuf byteBuf) {
        int connectionId = ChannelRegistry.getInstance().getConnectionId(context.channel().id().asShortText());
        MySQLQueryResult mysqlQueryResult = this.resultMap.get(connectionId);
        MySQLPacketPayload payload = new MySQLPacketPayload(byteBuf);
        if (null == mysqlQueryResult) {
            mysqlQueryResult = new MySQLQueryResult(payload);
            this.resultMap.put(connectionId, mysqlQueryResult);
        } else if (mysqlQueryResult.needColumnDefinition()) {
            mysqlQueryResult.addColumnDefinition(new ColumnDefinition41Packet(payload));
        } else {
            mysqlQueryResult.addTextResultSetRow(new TextResultSetRowPacket(payload, mysqlQueryResult.getColumnCount()));
        }
    }

    @ConstructorProperties(value={"dataSourceParameter", "dataSourceMetaData", "resultMap"})
    public MySQLResponseHandler(DataSourceParameter dataSourceParameter, DataSourceMetaData dataSourceMetaData, Map<Integer, MySQLQueryResult> resultMap) {
        this.dataSourceParameter = dataSourceParameter;
        this.dataSourceMetaData = dataSourceMetaData;
        this.resultMap = resultMap;
    }
}

