/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.config;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import io.shardingsphere.core.constant.properties.ShardingProperties;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.core.rule.ProxyAuthority;
import io.shardingsphere.core.yaml.YamlRuleConfiguration;
import io.shardingsphere.core.yaml.other.YamlServerConfiguration;
import io.shardingsphere.orchestration.internal.event.config.ProxyConfigurationEventBusEvent;
import io.shardingsphere.orchestration.internal.event.state.CircuitStateEventBusEvent;
import io.shardingsphere.orchestration.internal.event.state.ProxyDisabledStateEventBusEvent;
import io.shardingsphere.shardingproxy.config.BackendNIOConfiguration;
import io.shardingsphere.shardingproxy.config.RuleRegistry;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public final class ProxyContext {
    private static final ProxyContext INSTANCE = new ProxyContext();
    private List<String> schemaNames = new LinkedList<String>();
    private Map<String, RuleRegistry> ruleRegistryMap = new ConcurrentHashMap<String, RuleRegistry>();
    private ProxyAuthority proxyAuthority;
    private boolean showSQL;
    private boolean useNIO;
    private int maxConnectionsSizePerQuery;
    private int acceptorSize;
    private int executorSize;
    private TransactionType transactionType;
    private boolean openTracingEnable;
    private BackendNIOConfiguration backendNIOConfig;
    private boolean isCircuitBreak;

    public static ProxyContext getInstance() {
        return INSTANCE;
    }

    public void register() {
        ShardingEventBusInstance.getInstance().register((Object)this);
    }

    public void init(YamlServerConfiguration serverConfig, Map<String, Map<String, DataSourceParameter>> schemaDataSources, Map<String, YamlRuleConfiguration> schemaRules) {
        this.initServerConfiguration(serverConfig);
        for (Map.Entry<String, YamlRuleConfiguration> entry : schemaRules.entrySet()) {
            String schemaName = entry.getKey();
            this.schemaNames.add(schemaName);
            this.ruleRegistryMap.put(schemaName, new RuleRegistry(schemaName, schemaDataSources.get(schemaName), entry.getValue()));
        }
    }

    private void initServerConfiguration(YamlServerConfiguration serverConfig) {
        Properties properties = serverConfig.getProps();
        ShardingProperties shardingProperties = new ShardingProperties(null == properties ? new Properties() : properties);
        this.maxConnectionsSizePerQuery = (Integer)shardingProperties.getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY);
        this.transactionType = (Boolean)shardingProperties.getValue(ShardingPropertiesConstant.PROXY_TRANSACTION_ENABLED) != false ? TransactionType.XA : TransactionType.LOCAL;
        this.openTracingEnable = (Boolean)shardingProperties.getValue(ShardingPropertiesConstant.PROXY_OPENTRACING_ENABLED);
        this.showSQL = (Boolean)shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        this.acceptorSize = (Integer)shardingProperties.getValue(ShardingPropertiesConstant.ACCEPTOR_SIZE);
        this.executorSize = (Integer)shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        this.useNIO = false;
        int databaseConnectionCount = (Integer)shardingProperties.getValue(ShardingPropertiesConstant.PROXY_BACKEND_MAX_CONNECTIONS);
        int connectionTimeoutSeconds = (Integer)shardingProperties.getValue(ShardingPropertiesConstant.PROXY_BACKEND_CONNECTION_TIMEOUT_SECONDS);
        this.backendNIOConfig = new BackendNIOConfiguration(databaseConnectionCount, connectionTimeoutSeconds);
        this.proxyAuthority = serverConfig.getProxyAuthority();
    }

    public void initShardingMetaData(ShardingExecuteEngine executeEngine) {
        for (RuleRegistry each : this.ruleRegistryMap.values()) {
            each.initShardingMetaData(executeEngine);
        }
    }

    public boolean schemaExists(String schema) {
        return this.schemaNames.contains(schema);
    }

    public RuleRegistry getRuleRegistry(String schema) {
        return Strings.isNullOrEmpty((String)schema) ? null : this.ruleRegistryMap.get(schema);
    }

    public String getDefaultSchema() {
        return this.schemaNames.get(0);
    }

    @Subscribe
    public void renew(ProxyConfigurationEventBusEvent proxyConfigurationEventBusEvent) {
        this.initServerConfiguration(proxyConfigurationEventBusEvent.getServerConfiguration());
        for (Map.Entry<String, RuleRegistry> entry : this.ruleRegistryMap.entrySet()) {
            entry.getValue().getBackendDataSource().close();
        }
        this.ruleRegistryMap.clear();
        for (Map.Entry<String, RuleRegistry> entry : proxyConfigurationEventBusEvent.getSchemaDataSourceMap().entrySet()) {
            String schemaName = entry.getKey();
            this.ruleRegistryMap.put(schemaName, new RuleRegistry(schemaName, (Map)((Object)entry.getValue()), (YamlRuleConfiguration)proxyConfigurationEventBusEvent.getSchemaRuleMap().get(schemaName)));
        }
    }

    @Subscribe
    public void renewCircuitBreakerDataSourceNames(CircuitStateEventBusEvent circuitStateEventBusEvent) {
        this.isCircuitBreak = circuitStateEventBusEvent.isCircuitBreak();
    }

    @Subscribe
    public void renewDisabledDataSourceNames(ProxyDisabledStateEventBusEvent disabledStateEventBusEvent) {
        for (Map.Entry<String, RuleRegistry> entry : this.ruleRegistryMap.entrySet()) {
            entry.getValue().setDisabledDataSourceNames((Collection)disabledStateEventBusEvent.getDisabledSchemaDataSourceMap().get(entry.getKey()));
        }
    }

    private ProxyContext() {
    }

    public List<String> getSchemaNames() {
        return this.schemaNames;
    }

    public Map<String, RuleRegistry> getRuleRegistryMap() {
        return this.ruleRegistryMap;
    }

    public ProxyAuthority getProxyAuthority() {
        return this.proxyAuthority;
    }

    public boolean isShowSQL() {
        return this.showSQL;
    }

    public boolean isUseNIO() {
        return this.useNIO;
    }

    public int getMaxConnectionsSizePerQuery() {
        return this.maxConnectionsSizePerQuery;
    }

    public int getAcceptorSize() {
        return this.acceptorSize;
    }

    public int getExecutorSize() {
        return this.executorSize;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public boolean isOpenTracingEnable() {
        return this.openTracingEnable;
    }

    public BackendNIOConfiguration getBackendNIOConfig() {
        return this.backendNIOConfig;
    }

    public boolean isCircuitBreak() {
        return this.isCircuitBreak;
    }
}

