/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.config;

import io.shardingsphere.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.yaml.YamlRuleConfiguration;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCBackendDataSource;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.config.ProxyTableMetaDataConnectionManager;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public final class RuleRegistry {
    private final String schemaName;
    private final Map<String, DataSourceParameter> dataSources;
    private final ShardingRule shardingRule;
    private final MasterSlaveRule masterSlaveRule;
    private final JDBCBackendDataSource backendDataSource;
    private ShardingMetaData metaData;
    private Collection<String> disabledDataSourceNames = new LinkedList<String>();

    public RuleRegistry(String schemaName, Map<String, DataSourceParameter> dataSources, YamlRuleConfiguration rule) {
        this.schemaName = schemaName;
        this.dataSources = dataSources;
        this.shardingRule = new ShardingRule(null == rule.getShardingRule() ? new ShardingRuleConfiguration() : rule.getShardingRule().getShardingRuleConfiguration(), dataSources.keySet());
        this.masterSlaveRule = null == rule.getMasterSlaveRule() ? null : new MasterSlaveRule(rule.getMasterSlaveRule().getMasterSlaveRuleConfiguration());
        this.backendDataSource = new JDBCBackendDataSource(this);
    }

    public void initShardingMetaData(ShardingExecuteEngine executeEngine) {
        this.metaData = new ShardingMetaData(this.getDataSourceURLs(this.dataSources), this.shardingRule, DatabaseType.MySQL, executeEngine, (TableMetaDataConnectionManager)new ProxyTableMetaDataConnectionManager(this.backendDataSource), ProxyContext.getInstance().getMaxConnectionsSizePerQuery());
    }

    private Map<String, String> getDataSourceURLs(Map<String, DataSourceParameter> dataSourceParameters) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(dataSourceParameters.size(), 1.0f);
        for (Map.Entry<String, DataSourceParameter> entry : dataSourceParameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getUrl());
        }
        return result;
    }

    public boolean isMasterSlaveOnly() {
        return this.shardingRule.getTableRules().isEmpty() && null != this.masterSlaveRule;
    }

    public Map<String, DataSourceParameter> getDataSources() {
        if (!this.getDisabledDataSourceNames().isEmpty()) {
            return this.getAvailableDataSourceConfigurationMap();
        }
        return this.dataSources;
    }

    private Map<String, DataSourceParameter> getAvailableDataSourceConfigurationMap() {
        LinkedHashMap<String, DataSourceParameter> result = new LinkedHashMap<String, DataSourceParameter>(this.dataSources);
        for (String each : this.disabledDataSourceNames) {
            result.remove(each);
        }
        return result;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public MasterSlaveRule getMasterSlaveRule() {
        return this.masterSlaveRule;
    }

    public JDBCBackendDataSource getBackendDataSource() {
        return this.backendDataSource;
    }

    public ShardingMetaData getMetaData() {
        return this.metaData;
    }

    public Collection<String> getDisabledDataSourceNames() {
        return this.disabledDataSourceNames;
    }

    public void setDisabledDataSourceNames(Collection<String> disabledDataSourceNames) {
        this.disabledDataSourceNames = disabledDataSourceNames;
    }
}

