/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.shardingsphere.shardingproxy.backend.BackendExecutorContext;
import io.shardingsphere.shardingproxy.backend.netty.client.BackendNettyClientManager;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.frontend.common.netty.ServerHandlerInitializer;

public final class ShardingProxy {
    private static final ProxyContext PROXY_CONTEXT = ProxyContext.getInstance();
    private final BackendExecutorContext backendExecutorContext = BackendExecutorContext.getInstance();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private EventLoopGroup userGroup;

    public ShardingProxy() {
        PROXY_CONTEXT.initShardingMetaData(this.backendExecutorContext.getExecuteEngine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int port) throws InterruptedException {
        try {
            if (PROXY_CONTEXT.isUseNIO()) {
                BackendNettyClientManager.getInstance().start();
            }
            ServerBootstrap bootstrap = new ServerBootstrap();
            this.bossGroup = this.createEventLoopGroup();
            if (this.bossGroup instanceof EpollEventLoopGroup) {
                this.groupsEpoll(bootstrap);
            } else {
                this.groupsNio(bootstrap);
            }
            ChannelFuture future = bootstrap.bind(port).sync();
            future.channel().closeFuture().sync();
        }
        finally {
            this.userGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
            this.backendExecutorContext.getExecuteEngine().close();
            if (PROXY_CONTEXT.isUseNIO()) {
                BackendNettyClientManager.getInstance().stop();
            }
        }
    }

    private EventLoopGroup createEventLoopGroup() {
        try {
            return new EpollEventLoopGroup(1);
        }
        catch (UnsatisfiedLinkError ex) {
            return new NioEventLoopGroup(1);
        }
    }

    private void groupsEpoll(ServerBootstrap bootstrap) {
        this.workerGroup = new EpollEventLoopGroup();
        this.userGroup = new EpollEventLoopGroup(PROXY_CONTEXT.getAcceptorSize());
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(EpollServerSocketChannel.class)).option(EpollChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x800000, 0x1000000))).option(EpollChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(EpollChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerHandlerInitializer(this.userGroup));
    }

    private void groupsNio(ServerBootstrap bootstrap) {
        this.workerGroup = new NioEventLoopGroup();
        this.userGroup = new NioEventLoopGroup(PROXY_CONTEXT.getAcceptorSize());
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)100)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x800000, 0x1000000))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerHandlerInitializer(this.userGroup));
    }
}

