/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend.common;

import io.netty.channel.EventLoopGroup;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandler;
import io.shardingsphere.shardingproxy.frontend.mysql.MySQLFrontendHandler;

public final class FrontendHandlerFactory {
    public static FrontendHandler createFrontendHandlerInstance(DatabaseType databaseType, EventLoopGroup userGroup) {
        switch (databaseType) {
            case MySQL: {
                return new MySQLFrontendHandler(userGroup);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type '%s'", databaseType));
    }

    private FrontendHandlerFactory() {
    }
}

