/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend.common.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandlerFactory;
import io.shardingsphere.shardingproxy.transport.common.codec.PacketCodecFactory;
import java.beans.ConstructorProperties;

public final class ServerHandlerInitializer
extends ChannelInitializer<SocketChannel> {
    private final EventLoopGroup userGroup;

    protected void initChannel(SocketChannel socketChannel) {
        ChannelPipeline pipeline = socketChannel.pipeline();
        pipeline.addLast(new ChannelHandler[]{PacketCodecFactory.newInstance(DatabaseType.MySQL)});
        pipeline.addLast(new ChannelHandler[]{FrontendHandlerFactory.createFrontendHandlerInstance(DatabaseType.MySQL, this.userGroup)});
    }

    @ConstructorProperties(value={"userGroup"})
    public ServerHandlerInitializer(EventLoopGroup userGroup) {
        this.userGroup = userGroup;
    }
}

