/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend.mysql;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandler;
import io.shardingsphere.shardingproxy.frontend.common.executor.ExecutorGroup;
import io.shardingsphere.shardingproxy.runtime.ChannelRegistry;
import io.shardingsphere.shardingproxy.transport.common.packet.DatabasePacket;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacketFactory;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryCommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.AuthorityHandler;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.ConnectionIdGenerator;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.HandshakePacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.HandshakeResponse41Packet;
import io.shardingsphere.spi.root.RootInvokeHook;
import io.shardingsphere.spi.root.SPIRootInvokeHook;
import java.beans.ConstructorProperties;
import java.sql.SQLException;

public final class MySQLFrontendHandler
extends FrontendHandler {
    private final EventLoopGroup eventLoopGroup;
    private final AuthorityHandler authorityHandler = new AuthorityHandler();
    private final RootInvokeHook rootInvokeHook = new SPIRootInvokeHook();

    @Override
    protected void handshake(ChannelHandlerContext context) {
        int connectionId = ConnectionIdGenerator.getInstance().nextId();
        ChannelRegistry.getInstance().putConnectionId(context.channel().id().asShortText(), connectionId);
        context.writeAndFlush((Object)new HandshakePacket(connectionId, this.authorityHandler.getAuthPluginData()));
    }

    @Override
    protected void auth(ChannelHandlerContext context, ByteBuf message) {
        try (MySQLPacketPayload payload = new MySQLPacketPayload(message);){
            HandshakeResponse41Packet response41 = new HandshakeResponse41Packet(payload);
            if (this.authorityHandler.login(response41.getUsername(), response41.getAuthResponse())) {
                if (!Strings.isNullOrEmpty((String)response41.getDatabase()) && !ProxyContext.getInstance().schemaExists(response41.getDatabase())) {
                    context.writeAndFlush((Object)new ErrPacket(response41.getSequenceId() + 1, ServerErrorCode.ER_BAD_DB_ERROR, response41.getDatabase()));
                    return;
                }
                this.setCurrentSchema(response41.getDatabase());
                context.writeAndFlush((Object)new OKPacket(response41.getSequenceId() + 1));
            } else {
                context.writeAndFlush((Object)new ErrPacket(response41.getSequenceId() + 1, ServerErrorCode.ER_ACCESS_DENIED_ERROR, response41.getUsername(), "localhost", 0 == response41.getAuthResponse().length ? "NO" : "YES"));
            }
        }
    }

    @Override
    protected void executeCommand(ChannelHandlerContext context, ByteBuf message) {
        new ExecutorGroup(this.eventLoopGroup, context.channel().id()).getExecutorService().execute(new CommandExecutor(context, message, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelWritabilityChanged(ChannelHandlerContext context) {
        if (context.channel().isWritable()) {
            MySQLFrontendHandler mySQLFrontendHandler = this;
            synchronized (mySQLFrontendHandler) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    @ConstructorProperties(value={"eventLoopGroup"})
    public MySQLFrontendHandler(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    class CommandExecutor
    implements Runnable {
        private final ChannelHandlerContext context;
        private final ByteBuf message;
        private final FrontendHandler frontendHandler;
        private int currentSequenceId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MySQLFrontendHandler.this.rootInvokeHook.start();
            int connectionSize = 0;
            try (MySQLPacketPayload payload = new MySQLPacketPayload(this.message);
                 BackendConnection backendConnection = new BackendConnection();){
                MySQLFrontendHandler.this.setBackendConnection(backendConnection);
                CommandPacket commandPacket = this.getCommandPacket(payload, backendConnection, this.frontendHandler);
                Optional<CommandResponsePackets> responsePackets = commandPacket.execute();
                if (!responsePackets.isPresent()) {
                    return;
                }
                for (DatabasePacket each : ((CommandResponsePackets)responsePackets.get()).getPackets()) {
                    this.context.writeAndFlush((Object)each);
                }
                if (commandPacket instanceof QueryCommandPacket && !(((CommandResponsePackets)responsePackets.get()).getHeadPacket() instanceof OKPacket) && !(((CommandResponsePackets)responsePackets.get()).getHeadPacket() instanceof ErrPacket)) {
                    this.writeMoreResults((QueryCommandPacket)commandPacket, ((CommandResponsePackets)responsePackets.get()).getPackets().size());
                }
                connectionSize = backendConnection.getConnectionSize();
            }
            catch (SQLException ex) {
                this.context.writeAndFlush((Object)new ErrPacket(++this.currentSequenceId, ex));
            }
            catch (Exception ex) {
                this.context.writeAndFlush((Object)new ErrPacket(1, ServerErrorCode.ER_STD_UNKNOWN_EXCEPTION, ex.getMessage()));
            }
            finally {
                MySQLFrontendHandler.this.rootInvokeHook.finish(connectionSize);
            }
        }

        private CommandPacket getCommandPacket(MySQLPacketPayload payload, BackendConnection backendConnection, FrontendHandler frontendHandler) throws SQLException {
            int sequenceId = payload.readInt1();
            int connectionId = ChannelRegistry.getInstance().getConnectionId(this.context.channel().id().asShortText());
            return CommandPacketFactory.newInstance(sequenceId, connectionId, payload, backendConnection, frontendHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeMoreResults(QueryCommandPacket queryCommandPacket, int headPacketsCount) throws SQLException {
            if (!this.context.channel().isActive()) {
                return;
            }
            this.currentSequenceId = headPacketsCount;
            while (queryCommandPacket.next()) {
                while (!this.context.channel().isWritable() && this.context.channel().isActive()) {
                    MySQLFrontendHandler mySQLFrontendHandler = MySQLFrontendHandler.this;
                    synchronized (mySQLFrontendHandler) {
                        try {
                            ((Object)((Object)MySQLFrontendHandler.this)).wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                DatabasePacket resultValue = queryCommandPacket.getResultValue();
                this.currentSequenceId = resultValue.getSequenceId();
                this.context.writeAndFlush((Object)resultValue);
            }
            this.context.writeAndFlush((Object)new EofPacket(++this.currentSequenceId));
        }

        @ConstructorProperties(value={"context", "message", "frontendHandler"})
        public CommandExecutor(ChannelHandlerContext context, ByteBuf message, FrontendHandler frontendHandler) {
            this.context = context;
            this.message = message;
            this.frontendHandler = frontendHandler;
        }
    }
}

