/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.rewrite;

import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.token.SQLToken;
import io.shardingsphere.core.parsing.parser.token.SchemaToken;
import io.shardingsphere.core.rewrite.SQLBuilder;
import io.shardingsphere.core.rewrite.placeholder.SchemaPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.ShardingPlaceholder;
import io.shardingsphere.core.rule.MasterSlaveRule;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public final class MasterSlaveSQLRewriteEngine {
    private final MasterSlaveRule masterSlaveRule;
    private final String originalSQL;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLStatement sqlStatement;
    private final ShardingMetaData metaData;

    public MasterSlaveSQLRewriteEngine(MasterSlaveRule masterSlaveRule, String originalSQL, SQLStatement sqlStatement, ShardingMetaData metaData) {
        this.masterSlaveRule = masterSlaveRule;
        this.originalSQL = originalSQL;
        this.sqlStatement = sqlStatement;
        this.metaData = metaData;
        this.sqlTokens.addAll(sqlStatement.getSqlTokens());
    }

    public String rewrite() {
        if (this.sqlStatement.getSqlTokens().isEmpty()) {
            return this.originalSQL;
        }
        SQLBuilder result = new SQLBuilder(null);
        int count = 0;
        this.sortByBeginPosition();
        for (SQLToken each : this.sqlStatement.getSqlTokens()) {
            if (0 == count) {
                result.appendLiterals(this.originalSQL.substring(0, each.getBeginPosition()));
            }
            if (each instanceof SchemaToken) {
                this.appendSchemaPlaceholder(this.originalSQL, result, (SchemaToken)each, count, this.sqlStatement.getSqlTokens());
            }
            ++count;
        }
        return result.toSQL(this.masterSlaveRule, this.metaData.getDataSource());
    }

    private void appendSchemaPlaceholder(String sql, SQLBuilder sqlBuilder, SchemaToken schemaToken, int count, List<SQLToken> sqlTokens) {
        sqlBuilder.appendPlaceholder((ShardingPlaceholder)new SchemaPlaceholder(schemaToken.getSchemaName().toLowerCase(), null));
        int beginPosition = schemaToken.getBeginPosition() + schemaToken.getOriginalLiterals().length();
        int endPosition = sqlTokens.size() - 1 == count ? sql.length() : sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(sql.substring(beginPosition, endPosition));
    }

    private void sortByBeginPosition() {
        Collections.sort(this.sqlTokens, new Comparator<SQLToken>(){

            @Override
            public int compare(SQLToken o1, SQLToken o2) {
                return o1.getBeginPosition() - o2.getBeginPosition();
            }
        });
    }
}

