/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary;

import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.BinaryStatement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class BinaryStatementRegistry {
    private static final BinaryStatementRegistry INSTANCE = new BinaryStatementRegistry();
    private final ConcurrentMap<String, Integer> statementIdAssigner = new ConcurrentHashMap<String, Integer>(65535, 1.0f);
    private final ConcurrentMap<Integer, BinaryStatement> binaryStatements = new ConcurrentHashMap<Integer, BinaryStatement>(65535, 1.0f);
    private final AtomicInteger sequence = new AtomicInteger();

    public static BinaryStatementRegistry getInstance() {
        return INSTANCE;
    }

    public int register(String sql, int parametersCount) {
        Integer result = (Integer)this.statementIdAssigner.get(sql);
        if (null != result) {
            return result;
        }
        result = this.sequence.incrementAndGet();
        this.statementIdAssigner.putIfAbsent(sql, result);
        this.binaryStatements.putIfAbsent(result, new BinaryStatement(sql, parametersCount));
        return result;
    }

    public BinaryStatement getBinaryStatement(int statementId) {
        return (BinaryStatement)this.binaryStatements.get(statementId);
    }
}

