/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.BackendHandlerFactory;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandler;
import io.shardingsphere.shardingproxy.transport.common.packet.DatabasePacket;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.constant.NewParametersBoundFlag;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryCommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.BinaryStatement;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.BinaryStatementParameterType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.BinaryStatementRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.BinaryResultSetRowPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.NullBitmap;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.BinaryProtocolValue;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.binary.execute.protocol.BinaryProtocolValueFactory;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComStmtExecutePacket
implements QueryCommandPacket {
    private static final Logger log = LoggerFactory.getLogger(ComStmtExecutePacket.class);
    private static final int ITERATION_COUNT = 1;
    private static final int NULL_BITMAP_OFFSET = 0;
    private final int sequenceId;
    private final int statementId;
    private final BinaryStatement binaryStatement;
    private final int flags;
    private final NullBitmap nullBitmap;
    private final NewParametersBoundFlag newParametersBoundFlag;
    private final List<Object> parameters;
    private final BackendHandler backendHandler;

    public ComStmtExecutePacket(int sequenceId, int connectionId, MySQLPacketPayload payload, BackendConnection backendConnection, FrontendHandler frontendHandler) throws SQLException {
        this.sequenceId = sequenceId;
        this.statementId = payload.readInt4();
        this.binaryStatement = BinaryStatementRegistry.getInstance().getBinaryStatement(this.statementId);
        this.flags = payload.readInt1();
        Preconditions.checkArgument((1 == payload.readInt4() ? 1 : 0) != 0);
        int parametersCount = this.binaryStatement.getParametersCount();
        this.nullBitmap = new NullBitmap(parametersCount, 0);
        for (int i = 0; i < this.nullBitmap.getNullBitmap().length; ++i) {
            this.nullBitmap.getNullBitmap()[i] = payload.readInt1();
        }
        this.newParametersBoundFlag = NewParametersBoundFlag.valueOf(payload.readInt1());
        if (NewParametersBoundFlag.PARAMETER_TYPE_EXIST == this.newParametersBoundFlag) {
            this.binaryStatement.setParameterTypes(this.getParameterTypes(payload, parametersCount));
        }
        this.parameters = this.getParameters(payload, parametersCount);
        this.backendHandler = BackendHandlerFactory.newBinaryProtocolInstance(connectionId, sequenceId, this.binaryStatement.getSql(), this.parameters, backendConnection, DatabaseType.MySQL, frontendHandler);
    }

    private List<BinaryStatementParameterType> getParameterTypes(MySQLPacketPayload payload, int parametersCount) {
        ArrayList<BinaryStatementParameterType> result = new ArrayList<BinaryStatementParameterType>(parametersCount);
        for (int parameterIndex = 0; parameterIndex < parametersCount; ++parameterIndex) {
            ColumnType columnType = ColumnType.valueOf(payload.readInt1());
            int unsignedFlag = payload.readInt1();
            result.add(new BinaryStatementParameterType(columnType, unsignedFlag));
        }
        return result;
    }

    private List<Object> getParameters(MySQLPacketPayload payload, int parametersCount) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(parametersCount);
        for (int parameterIndex = 0; parameterIndex < parametersCount; ++parameterIndex) {
            BinaryProtocolValue binaryProtocolValue = BinaryProtocolValueFactory.getBinaryProtocolValue(this.binaryStatement.getParameterTypes().get(parameterIndex).getColumnType());
            result.add(this.nullBitmap.isNullParameter(parameterIndex) ? null : binaryProtocolValue.read(payload));
        }
        return result;
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt4(this.statementId);
        payload.writeInt1(this.flags);
        payload.writeInt4(1);
        for (int each : this.nullBitmap.getNullBitmap()) {
            payload.writeInt1(each);
        }
        payload.writeInt1(this.newParametersBoundFlag.getValue());
        int count = 0;
        for (Object each : this.parameters) {
            BinaryStatementParameterType parameterType = this.binaryStatement.getParameterTypes().get(count);
            payload.writeInt1(parameterType.getColumnType().getValue());
            payload.writeInt1(parameterType.getUnsignedFlag());
            payload.writeStringLenenc(null == each ? "" : each.toString());
            ++count;
        }
    }

    @Override
    public Optional<CommandResponsePackets> execute() {
        log.debug("COM_STMT_EXECUTE received for Sharding-Proxy: {}", (Object)this.statementId);
        if (ProxyContext.getInstance().isCircuitBreak()) {
            return Optional.of((Object)new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_CIRCUIT_BREAK_MODE, new Object[0])));
        }
        return Optional.of((Object)this.backendHandler.execute());
    }

    @Override
    public boolean next() throws SQLException {
        return this.backendHandler.next();
    }

    @Override
    public DatabasePacket getResultValue() throws SQLException {
        ResultPacket resultPacket = this.backendHandler.getResultValue();
        return new BinaryResultSetRowPacket(resultPacket.getSequenceId(), resultPacket.getColumnCount(), resultPacket.getData(), resultPacket.getColumnTypes());
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }
}

