/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.query;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.transaction.TransactionOperationType;
import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.event.transaction.xa.XATransactionEvent;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.BackendHandlerFactory;
import io.shardingsphere.shardingproxy.backend.ResultPacket;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.config.ProxyContext;
import io.shardingsphere.shardingproxy.frontend.common.FrontendHandler;
import io.shardingsphere.shardingproxy.transport.common.packet.DatabasePacket;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacketType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.QueryCommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.TextResultSetRowPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.OKPacket;
import io.shardingsphere.transaction.manager.ShardingTransactionManagerRegistry;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComQueryPacket
implements QueryCommandPacket {
    private static final Logger log = LoggerFactory.getLogger(ComQueryPacket.class);
    private final int sequenceId;
    private final String sql;
    private final BackendHandler backendHandler;

    public ComQueryPacket(int sequenceId, int connectionId, MySQLPacketPayload payload, BackendConnection backendConnection, FrontendHandler frontendHandler) {
        this.sequenceId = sequenceId;
        this.sql = payload.readStringEOF();
        this.backendHandler = BackendHandlerFactory.newTextProtocolInstance(connectionId, sequenceId, this.sql, backendConnection, DatabaseType.MySQL, frontendHandler);
    }

    public ComQueryPacket(int sequenceId, String sql) {
        this.sequenceId = sequenceId;
        this.sql = sql;
        this.backendHandler = null;
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(CommandPacketType.COM_QUERY.getValue());
        payload.writeStringEOF(this.sql);
    }

    @Override
    public Optional<CommandResponsePackets> execute() throws SQLException {
        log.debug("COM_QUERY received for Sharding-Proxy: {}", (Object)this.sql);
        if (ProxyContext.getInstance().isCircuitBreak()) {
            return Optional.of((Object)new CommandResponsePackets(new ErrPacket(1, ServerErrorCode.ER_CIRCUIT_BREAK_MODE, new Object[0])));
        }
        Optional operationType = TransactionOperationType.getOperationType((String)this.sql);
        if (!operationType.isPresent()) {
            return Optional.of((Object)this.backendHandler.execute());
        }
        if (TransactionType.XA == ProxyContext.getInstance().getTransactionType() && this.isInTransaction((TransactionOperationType)operationType.get())) {
            ShardingEventBusInstance.getInstance().post((Object)new XATransactionEvent((TransactionOperationType)operationType.get()));
        }
        return Optional.of((Object)new CommandResponsePackets(new OKPacket(1)));
    }

    private boolean isInTransaction(TransactionOperationType operationType) throws SQLException {
        return TransactionOperationType.ROLLBACK != operationType || 6 != ShardingTransactionManagerRegistry.getInstance().getShardingTransactionManager(TransactionType.XA).getStatus();
    }

    @Override
    public boolean next() throws SQLException {
        return this.backendHandler.next();
    }

    @Override
    public DatabasePacket getResultValue() throws SQLException {
        ResultPacket resultPacket = this.backendHandler.getResultValue();
        return new TextResultSetRowPacket(resultPacket.getSequenceId(), resultPacket.getData());
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }
}

