/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.generic;

import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ServerErrorCode;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import java.beans.ConstructorProperties;
import java.sql.SQLException;

public final class ErrPacket
implements MySQLPacket {
    public static final int HEADER = 255;
    private static final String SQL_STATE_MARKER = "#";
    private final int sequenceId;
    private final int errorCode;
    private final String sqlState;
    private final String errorMessage;

    public ErrPacket(int sequenceId, ServerErrorCode serverErrorCode, Object ... errorMessageArguments) {
        this(sequenceId, serverErrorCode.getErrorCode(), serverErrorCode.getSqlState(), String.format(serverErrorCode.getErrorMessage(), errorMessageArguments));
    }

    public ErrPacket(int sequenceId, SQLException cause) {
        this(sequenceId, cause.getErrorCode(), cause.getSQLState(), cause.getMessage());
    }

    public ErrPacket(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((255 == payload.readInt1() ? 1 : 0) != 0);
        this.errorCode = payload.readInt2();
        Preconditions.checkArgument((boolean)SQL_STATE_MARKER.equals(payload.readStringFix(1)));
        this.sqlState = payload.readStringFix(5);
        this.errorMessage = payload.readStringEOF();
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(255);
        payload.writeInt2(this.errorCode);
        payload.writeStringFix(SQL_STATE_MARKER);
        payload.writeStringFix(this.sqlState);
        payload.writeStringEOF(this.errorMessage);
    }

    @ConstructorProperties(value={"sequenceId", "errorCode", "sqlState", "errorMessage"})
    public ErrPacket(int sequenceId, int errorCode, String sqlState, String errorMessage) {
        this.sequenceId = sequenceId;
        this.errorCode = errorCode;
        this.sqlState = sqlState;
        this.errorMessage = errorMessage;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

