/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.generic;

import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.transport.mysql.constant.StatusFlag;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import java.beans.ConstructorProperties;

public final class OKPacket
implements MySQLPacket {
    public static final int HEADER = 0;
    private static final int STATUS_FLAG = StatusFlag.SERVER_STATUS_AUTOCOMMIT.getValue();
    private final int sequenceId;
    private final long affectedRows;
    private final long lastInsertId;
    private final int warnings;
    private final String info;

    public OKPacket(int sequenceId) {
        this(sequenceId, 0L, 0L, 0, "");
    }

    public OKPacket(int sequenceId, long affectedRows, long lastInsertId) {
        this(sequenceId, affectedRows, lastInsertId, 0, "");
    }

    public OKPacket(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((0 == payload.readInt1() ? 1 : 0) != 0);
        this.affectedRows = payload.readIntLenenc();
        this.lastInsertId = payload.readIntLenenc();
        payload.readInt2();
        this.warnings = payload.readInt2();
        this.info = payload.readStringEOF();
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(0);
        payload.writeIntLenenc(this.affectedRows);
        payload.writeIntLenenc(this.lastInsertId);
        payload.writeInt2(STATUS_FLAG);
        payload.writeInt2(this.warnings);
        payload.writeStringEOF(this.info);
    }

    @ConstructorProperties(value={"sequenceId", "affectedRows", "lastInsertId", "warnings", "info"})
    public OKPacket(int sequenceId, long affectedRows, long lastInsertId, int warnings, String info) {
        this.sequenceId = sequenceId;
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.warnings = warnings;
        this.info = info;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public String getInfo() {
        return this.info;
    }
}

