/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.handshake;

import com.google.common.base.Preconditions;
import io.shardingsphere.shardingproxy.transport.mysql.constant.CapabilityFlag;
import io.shardingsphere.shardingproxy.transport.mysql.constant.StatusFlag;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.AuthPluginData;

public final class HandshakePacket
implements MySQLPacket {
    private final int protocolVersion = 10;
    private final String serverVersion = "5.6.0-Sharding-Proxy 3.0.0.M4";
    private final int capabilityFlagsLower = CapabilityFlag.calculateHandshakeCapabilityFlagsLower();
    private final StatusFlag statusFlag = StatusFlag.SERVER_STATUS_AUTOCOMMIT;
    private final int capabilityFlagsUpper = CapabilityFlag.calculateHandshakeCapabilityFlagsUpper();
    private final int sequenceId;
    private final int connectionId;
    private final AuthPluginData authPluginData;

    public HandshakePacket(int connectionId, AuthPluginData authPluginData) {
        this.sequenceId = 0;
        this.connectionId = connectionId;
        this.authPluginData = authPluginData;
    }

    public HandshakePacket(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((10 == payload.readInt1() ? 1 : 0) != 0);
        payload.readStringNul();
        this.connectionId = payload.readInt4();
        byte[] authPluginDataPart1 = payload.readStringNulByBytes();
        payload.readInt2();
        payload.readInt1();
        Preconditions.checkArgument((this.statusFlag.getValue() == payload.readInt2() ? 1 : 0) != 0);
        payload.readInt2();
        payload.readInt1();
        payload.skipReserved(10);
        byte[] authPluginDataPart2 = payload.readStringNulByBytes();
        this.authPluginData = new AuthPluginData(authPluginDataPart1, authPluginDataPart2);
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(10);
        payload.writeStringNul("5.6.0-Sharding-Proxy 3.0.0.M4");
        payload.writeInt4(this.connectionId);
        payload.writeStringNul(new String(this.authPluginData.getAuthPluginDataPart1()));
        payload.writeInt2(this.capabilityFlagsLower);
        payload.writeInt1(33);
        payload.writeInt2(this.statusFlag.getValue());
        payload.writeInt2(this.capabilityFlagsUpper);
        payload.writeInt1(0);
        payload.writeReserved(10);
        payload.writeStringNul(new String(this.authPluginData.getAuthPluginDataPart2()));
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public AuthPluginData getAuthPluginData() {
        return this.authPluginData;
    }
}

