/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.handshake;

import io.shardingsphere.shardingproxy.transport.mysql.constant.CapabilityFlag;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import java.beans.ConstructorProperties;

public final class HandshakeResponse41Packet
implements MySQLPacket {
    private final int sequenceId;
    private final int capabilityFlags;
    private final int maxPacketSize;
    private final int characterSet;
    private final String username;
    private final byte[] authResponse;
    private final String database;

    public HandshakeResponse41Packet(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        this.capabilityFlags = payload.readInt4();
        this.maxPacketSize = payload.readInt4();
        this.characterSet = payload.readInt1();
        payload.skipReserved(23);
        this.username = payload.readStringNul();
        this.authResponse = this.readAuthResponse(payload);
        this.database = this.readDatabase(payload);
    }

    private byte[] readAuthResponse(MySQLPacketPayload payload) {
        if (0 != (this.capabilityFlags & CapabilityFlag.CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA.getValue())) {
            return payload.readStringLenencByBytes();
        }
        if (0 != (this.capabilityFlags & CapabilityFlag.CLIENT_SECURE_CONNECTION.getValue())) {
            int length = payload.readInt1();
            return payload.readStringFixByBytes(length);
        }
        return payload.readStringNulByBytes();
    }

    private String readDatabase(MySQLPacketPayload payload) {
        return 0 != (this.capabilityFlags & CapabilityFlag.CLIENT_CONNECT_WITH_DB.getValue()) ? payload.readStringNul() : null;
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt4(this.capabilityFlags);
        payload.writeInt4(this.maxPacketSize);
        payload.writeInt1(this.characterSet);
        payload.writeReserved(23);
        payload.writeStringNul(this.username);
        this.writeAuthResponse(payload);
        this.writeDatabase(payload);
    }

    private void writeAuthResponse(MySQLPacketPayload payload) {
        if (0 != (this.capabilityFlags & CapabilityFlag.CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA.getValue())) {
            payload.writeStringLenenc(new String(this.authResponse));
        } else if (0 != (this.capabilityFlags & CapabilityFlag.CLIENT_SECURE_CONNECTION.getValue())) {
            payload.writeInt1(this.authResponse.length);
            payload.writeBytes(this.authResponse);
        } else {
            payload.writeStringNul(new String(this.authResponse));
        }
    }

    private void writeDatabase(MySQLPacketPayload payload) {
        if (0 != (this.capabilityFlags & CapabilityFlag.CLIENT_CONNECT_WITH_DB.getValue())) {
            payload.writeStringNul(this.database);
        }
    }

    @ConstructorProperties(value={"sequenceId", "capabilityFlags", "maxPacketSize", "characterSet", "username", "authResponse", "database"})
    public HandshakeResponse41Packet(int sequenceId, int capabilityFlags, int maxPacketSize, int characterSet, String username, byte[] authResponse, String database) {
        this.sequenceId = sequenceId;
        this.capabilityFlags = capabilityFlags;
        this.maxPacketSize = maxPacketSize;
        this.characterSet = characterSet;
        this.username = username;
        this.authResponse = authResponse;
        this.database = database;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getAuthResponse() {
        return this.authResponse;
    }

    public String getDatabase() {
        return this.database;
    }
}

