/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.schema;

import io.shiftleft.codepropertygraph.schema.Base;
import io.shiftleft.codepropertygraph.schema.FileSystem;
import io.shiftleft.codepropertygraph.schema.Method$;
import io.shiftleft.codepropertygraph.schema.Type;
import overflowdb.schema.AbstractNodeType;
import overflowdb.schema.HasProperties;
import overflowdb.schema.NodeBaseType;
import overflowdb.schema.NodeType;
import overflowdb.schema.Property;
import overflowdb.schema.SchemaBuilder;
import overflowdb.schema.SchemaInfo;
import overflowdb.schema.SchemaInfo$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Method {
    public static Schema apply(SchemaBuilder schemaBuilder, Base.Schema schema, Type.Schema schema2, FileSystem.Schema schema3) {
        return Method$.MODULE$.apply(schemaBuilder, schema, schema2, schema3);
    }

    public static String description() {
        return Method$.MODULE$.description();
    }

    public static int docIndex() {
        return Method$.MODULE$.docIndex();
    }

    public static boolean providedByFrontend() {
        return Method$.MODULE$.providedByFrontend();
    }

    public static class Schema {
        private final Property signature;
        private final NodeType method;
        private final Property isVariadic;
        private final NodeType methodParameterIn;
        private final NodeType methodParameterOut;
        private final NodeType methodReturn;

        public Schema(SchemaBuilder builder, Base.Schema base, Type.Schema typeDeclSchema, FileSystem.Schema fs) {
            SchemaInfo schemaInfo = SchemaInfo$.MODULE$.forClass(this.getClass());
            this.signature = (Property)builder.addProperty("SIGNATURE", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                    |The method signature encodes the types of parameters in a string.\n                    |The string SHOULD be human readable and suitable for differentiating methods\n                    |with different parameter types sufficiently to allow for resolving of\n                    |function overloading. The present specification does not enforce a strict\n                    |format for the signature, that is, it can be chosen by the frontend\n                    |implementor to fit the source language.\n                    |")), schemaInfo).mandatory((Object)"").protoId(22);
            this.method = (NodeType)((AbstractNodeType)((HasProperties)builder.addNodeType("METHOD", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Programming languages offer many closely-related concepts for describing blocks\n            |of code that can be executed with input parameters and return output parameters,\n            |possibly causing side effects. In the CPG specification, we refer to all of these\n            |concepts (procedures, functions, methods, etc.) as methods. A single METHOD node\n            |must exist for each method found in the source program.\n            |\n            |The `FULL_NAME` field specifies the method's fully-qualified name, including\n            |information about the namespace it is contained in if applicable, the name field\n            |is the function's short name. The field `IS_EXTERNAL` indicates whether it was\n            |possible to identify a method body for the method. This is true for methods that\n            |are defined in the source program, and false for methods that are dynamically\n            |linked to the program, that is, methods that exist in an external dependency.\n            |\n            |Line and column number information is specified in the optional fields\n            |`LINE_NUMBER`, `COLUMN_NUMBER`, `LINE_NUMBER_END`, and `COLUMN_NUMBER_END` and\n            |the name of the source file is specified in `FILENAME`. An optional hash value\n            |MAY be calculated over the function contents and included in the `HASH` field.\n            |\n            |Finally, the fully qualified name of the program constructs that the method\n            |is immediately contained in is stored in the `AST_PARENT_FULL_NAME` field\n            |and its type is indicated in the `AST_PARENT_TYPE` field to be one of\n            |`METHOD`, `TYPE_DECL` or `NAMESPACE_BLOCK`.\n            |")), schemaInfo).protoId(1)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{base.fullName(), base.isExternal(), this.signature(), fs.lineNumberEnd(), fs.columnNumberEnd(), fs.filename(), base.hash()})).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{base.astParentType(), base.astParentFullName()}))).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{base.declaration()}));
            this.isVariadic = (Property)builder.addProperty("IS_VARIADIC", (Property.ValueType)Property.ValueType$.Boolean$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                    |Specifies whether a parameter is the variadic argument handling parameter of\n                    |a variadic method. Only one parameter of a method is allowed to have this\n                    |property set to true.\n                    |")), schemaInfo).mandatory((Object)BoxesRunTime.boxToBoolean((boolean)false)).protoId(221);
            this.methodParameterIn = (NodeType)((AbstractNodeType)((HasProperties)builder.addNodeType("METHOD_PARAMETER_IN", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |This node represents a formal input parameter. The field `NAME` contains its\n            |name, while the field `TYPE_FULL_NAME` contains the fully qualified type name.\n            |")), schemaInfo).protoId(34)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeDeclSchema.typeFullName(), this.isVariadic(), base.index()}))).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{base.declaration()}));
            this.methodParameterOut = (NodeType)((AbstractNodeType)((HasProperties)builder.addNodeType("METHOD_PARAMETER_OUT", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents a formal output parameter. Corresponding output parameters\n            |for input parameters MUST NOT be created by the frontend as they are automatically\n            |created upon first loading the CPG.\n            |")), schemaInfo).protoId(33)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeDeclSchema.typeFullName(), this.isVariadic(), base.index()}))).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{base.declaration()}));
            this.methodReturn = (NodeType)((HasProperties)builder.addNodeType("METHOD_RETURN", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents an (unnamed) formal method return parameter. It carries its\n            |fully qualified type name in `TYPE_FULL_NAME`. The `CODE` field MAY be set freely,\n            |e.g., to the constant `RET`, however, subsequent layer creators MUST NOT depend\n            |on this value.\n            |")), schemaInfo).protoId(3)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeDeclSchema.typeFullName()}));
            this.method().addOutEdge(fs.sourceFile(), (AbstractNodeType)fs.file(), this.method().addOutEdge$default$3(), this.method().addOutEdge$default$4(), this.method().addOutEdge$default$5(), this.method().addOutEdge$default$6(), "method", this.method().addOutEdge$default$8());
        }

        public Property<String> signature() {
            return this.signature;
        }

        public NodeType method() {
            return this.method;
        }

        public Property<Object> isVariadic() {
            return this.isVariadic;
        }

        public NodeType methodParameterIn() {
            return this.methodParameterIn;
        }

        public NodeType methodParameterOut() {
            return this.methodParameterOut;
        }

        public NodeType methodReturn() {
            return this.methodReturn;
        }
    }
}

