/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.schema;

import io.shiftleft.codepropertygraph.schema.Ast$;
import io.shiftleft.codepropertygraph.schema.Base;
import io.shiftleft.codepropertygraph.schema.CpgSchema$PropertyDefaults$;
import io.shiftleft.codepropertygraph.schema.FileSystem;
import io.shiftleft.codepropertygraph.schema.Method;
import io.shiftleft.codepropertygraph.schema.Namespace;
import io.shiftleft.codepropertygraph.schema.Type;
import overflowdb.schema.AbstractNodeType;
import overflowdb.schema.Constant;
import overflowdb.schema.Constant$;
import overflowdb.schema.EdgeType;
import overflowdb.schema.HasProperties;
import overflowdb.schema.NodeBaseType;
import overflowdb.schema.NodeType;
import overflowdb.schema.Property;
import overflowdb.schema.SchemaBuilder;
import overflowdb.schema.SchemaInfo;
import overflowdb.schema.SchemaInfo$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Ast {
    public static Schema apply(SchemaBuilder schemaBuilder, Base.Schema schema, Namespace.Schema schema2, Method.Schema schema3, Type.Schema schema4, FileSystem.Schema schema5) {
        return Ast$.MODULE$.apply(schemaBuilder, schema, schema2, schema3, schema4, schema5);
    }

    public static String description() {
        return Ast$.MODULE$.description();
    }

    public static int docIndex() {
        return Ast$.MODULE$.docIndex();
    }

    public static boolean providedByFrontend() {
        return Ast$.MODULE$.providedByFrontend();
    }

    public static class Schema {
        private final Property order;
        private final NodeBaseType astNode;
        private final NodeType block;
        private final NodeType literal;
        private final NodeType local;
        private final NodeType identifier;
        private final Property canonicalName;
        private final NodeType fieldIdentifier;
        private final Property modifierType;
        private final Seq modifierTypes;
        private final NodeType modifier;
        private final NodeType jumpTarget;
        private final NodeType jumpLabel;
        private final NodeType methodRef;
        private final NodeType typeRef;
        private final NodeType ret;
        private final Property controlStructureType;
        private final Seq controlStructureTypes;
        private final NodeType controlStructure;
        private final NodeType unknown;
        private final EdgeType ast;
        private final EdgeType condition;
        private final NodeBaseType callRepr;
        private final NodeType callNode;
        private final NodeBaseType expression;

        public Schema(SchemaBuilder builder, Base.Schema base, Namespace.Schema namespaces, Method.Schema methodSchema, Type.Schema typeSchema, FileSystem.Schema fs) {
            SchemaInfo schemaInfo = SchemaInfo$.MODULE$.forClass(this.getClass());
            this.order = (Property)builder.addProperty("ORDER", (Property.ValueType)Property.ValueType$.Int$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This integer indicates the position of the node among\n            |its siblings in the AST. The left-most child has an\n            |order of 0.\n            |")), schemaInfo).mandatory((Object)BoxesRunTime.boxToInteger((int)-1)).protoId(4);
            this.astNode = (NodeBaseType)builder.addNodeBaseType("AST_NODE", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This is the base type for all nodes of the abstract syntax tree (AST). An AST\n                    |node has a `CODE` and an `ORDER` field. The `CODE` field contains the\n                    |code (verbatim) represented by the AST node. The `ORDER` field contains the\n                    |nodes position among its siblings, encoded as an integer where the left most\n                    |sibling has the position `0`.\n                    |\n                    |AST nodes contain optional `LINE_NUMBER` and `COLUMN_NUMBER` fields. For\n                    |source-based frontends, these fields contain the start line number and\n                    |start column number of the code represented by the node.\n                    |For machine-code-based and bytecode-based frontends, `LINE_NUMBER` contains\n                    |the address at which the code starts while `COLUMN_NUMBER` is undefined.\n                    |")), schemaInfo).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{this.order(), base.code()})).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{fs.lineNumber(), fs.columnNumber()}));
            methodSchema.method().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            methodSchema.methodParameterIn().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            methodSchema.methodParameterOut().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            typeSchema.typeDecl().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            typeSchema.member().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            typeSchema.typeParameter().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            typeSchema.typeArgument().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            fs.file().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            namespaces.namespaceBlock().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            this.block = (NodeType)((HasProperties)builder.addNodeType("BLOCK", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents a compound statement. Compound statements are used in many languages to allow\n                    |grouping a sequence of statements. For example, in C and Java, compound statements\n                    |are statements enclosed by curly braces. Function/Method bodies are compound\n                    |statements. We do not use the term \"compound statement\" because \"statement\" would\n                    |imply that the block does not yield a value upon evaluation, that is, that it is\n                    |not an expression. This is true in languages such as C and Java, but not for languages\n                    |such as Scala where the value of the block is given by that of the last expression it\n                    |contains. In fact, the Scala grammar uses the term \"BlockExpr\" (short for\n                    |\"block expression\") to describe what in the CPG we call \"Block\".\n                    |")), schemaInfo).protoId(31)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeSchema.typeFullName()}));
            this.literal = (NodeType)((HasProperties)builder.addNodeType("LITERAL", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents a literal such as an integer or string constant. Literals\n            |are symbols included in the code in verbatim form and which are immutable.\n            |The `TYPE_FULL_NAME` field stores the literal's fully-qualified type name,\n            |e.g., `java.lang.Integer`.\n            |")), schemaInfo).protoId(8)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeSchema.typeFullName()}));
            this.local = (NodeType)((AbstractNodeType)((HasProperties)builder.addNodeType("LOCAL", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents a local variable. Its fully qualified type name is stored\n            |in the `TYPE_FULL_NAME` field and its name in the `NAME` field. The `CODE` field\n            |contains the entire local variable declaration without initialization, e.g., for\n            |`int x = 10;`, it contains `int x`.\n            |")), schemaInfo).protoId(23)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeSchema.typeFullName()}))).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{base.declaration(), this.astNode()}));
            this.identifier = (NodeType)((HasProperties)builder.addNodeType("IDENTIFIER", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents an identifier as used when referring to a variable by name.\n            |It holds the identifier's name in the `NAME` field and its fully-qualified type\n            |name in `TYPE_FULL_NAME`.\n            |")), schemaInfo).protoId(27)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeSchema.typeFullName(), base.name()}));
            this.canonicalName = (Property)builder.addProperty("CANONICAL_NAME", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This field holds the canonical name of a `FIELD_IDENTIFIER`. It is typically\n                    |identical to the CODE field, but canonicalized according to source language\n                    |semantics. Human readable names are preferable. `FIELD_IDENTIFIER` nodes must\n                    |share identical `CANONICAL_NAME` if and\n                    |only if they alias, e.g., in C-style unions (if the aliasing relationship is\n                    |unknown or there are partial overlaps, then one must make a reasonable guess,\n                    |and trade off between false negatives and false positives).\n                    |")), schemaInfo).mandatory((Object)CpgSchema$PropertyDefaults$.MODULE$.String()).protoId(2001092);
            this.fieldIdentifier = (NodeType)((HasProperties)builder.addNodeType("FIELD_IDENTIFIER", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents the field accessed in a field access, e.g., in\n                    |`a.b`, it represents `b`. The field name as it occurs in the code is\n                    |stored in the `CODE` field. This may mean that the `CODE` field holds\n                    |an expression. The `CANONICAL_NAME` field MAY contain the same value is\n                    |the `CODE` field but SHOULD contain the normalized name that results\n                    |from evaluating `CODE` as an expression if such an evaluation is\n                    |possible for the language frontend. The objective is to store an identifier\n                    |in `CANONICAL_NAME` that is the same for two nodes iff they refer to the\n                    |same field, regardless of whether they use the same expression to reference\n                    |it.\n                    |")), schemaInfo).protoId(2001081)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{this.canonicalName()}));
            this.modifierType = (Property)builder.addProperty("MODIFIER_TYPE", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The modifier type is a free-form string. The following are known modifier types:\n            |`STATIC`, `PUBLIC`, `PROTECTED`, `PRIVATE`, `ABSTRACT`, `NATIVE`, `CONSTRUCTOR`, `VIRTUAL`.\n            |")), schemaInfo).mandatory((Object)CpgSchema$PropertyDefaults$.MODULE$.String()).protoId(26);
            this.modifierTypes = builder.addConstants("ModifierTypes", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Constant[]{(Constant)Constant$.MODULE$.apply("STATIC", "STATIC", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The static modifier", schemaInfo).protoId(1), (Constant)Constant$.MODULE$.apply("PUBLIC", "PUBLIC", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The public modifier", schemaInfo).protoId(2), (Constant)Constant$.MODULE$.apply("PROTECTED", "PROTECTED", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The protected modifier", schemaInfo).protoId(3), (Constant)Constant$.MODULE$.apply("PRIVATE", "PRIVATE", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The private modifier", schemaInfo).protoId(4), (Constant)Constant$.MODULE$.apply("ABSTRACT", "ABSTRACT", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The abstract modifier", schemaInfo).protoId(5), (Constant)Constant$.MODULE$.apply("NATIVE", "NATIVE", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The native modifier", schemaInfo).protoId(6), (Constant)Constant$.MODULE$.apply("CONSTRUCTOR", "CONSTRUCTOR", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The constructor modifier", schemaInfo).protoId(7), (Constant)Constant$.MODULE$.apply("VIRTUAL", "VIRTUAL", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The virtual modifier", schemaInfo).protoId(8), (Constant)Constant$.MODULE$.apply("INTERNAL", "INTERNAL", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The internal modifier", schemaInfo).protoId(9), (Constant)Constant$.MODULE$.apply("FINAL", "FINAL", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The final modifier", schemaInfo).protoId(10), (Constant)Constant$.MODULE$.apply("READONLY", "READONLY", (Property.ValueType)Property.ValueType$.String$.MODULE$, "The readonly modifier", schemaInfo).protoId(11), (Constant)Constant$.MODULE$.apply("MODULE", "MODULE", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Indicate that a method defines a module in the sense e.g. a python module does with the creation of a module object", schemaInfo).protoId(12), (Constant)Constant$.MODULE$.apply("LAMBDA", "LAMBDA", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Indicate that a method is an anonymous function, lambda, or closure", schemaInfo).protoId(13)}));
            this.modifier = (NodeType)((AbstractNodeType)((HasProperties)builder.addNodeType("MODIFIER", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This field represents a (language-dependent) modifier such as `static`, `private`\n            |or `public`. Unlike most other AST nodes, it is NOT an expression, that is, it\n            |cannot be evaluated and cannot be passed as an argument in function calls.\n            |")), schemaInfo).protoId(300)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{this.modifierType()}))).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            this.jumpTarget = (NodeType)((AbstractNodeType)((HasProperties)builder.addNodeType("JUMP_TARGET", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A jump target is any location in the code that has been specifically marked\n            |as the target of a jump, e.g., via a label. The `NAME` field holds the name of\n            |the label while the `PARSER_TYPE_NAME` field holds the name of language construct\n            |that this jump target is created from, e.g., \"Label\".\n            |")), schemaInfo).protoId(340)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{base.name(), base.parserTypeName()}))).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            this.jumpLabel = (NodeType)((AbstractNodeType)((HasProperties)builder.addNodeType("JUMP_LABEL", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A jump label specifies the label and thus the JUMP_TARGET of control structures\n                    |BREAK and CONTINUE. The `NAME` field holds the name of the label while the\n                    |`PARSER_TYPE_NAME` field holds the name of language construct that this jump\n                    |label is created from, e.g., \"Label\".\n                    |")), schemaInfo).protoId(341)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{base.name(), base.parserTypeName()}))).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            this.methodRef = (NodeType)((HasProperties)builder.addNodeType("METHOD_REF", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents a reference to a method/function/procedure as it\n            |appears when a method is passed as an argument in a call. The `METHOD_FULL_NAME`\n            |field holds the fully-qualified name of the referenced method and the\n            |`TYPE_FULL_NAME` holds its fully-qualified type name.\n            |")), schemaInfo).protoId(333)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeSchema.typeFullName()}));
            this.typeRef = (NodeType)((HasProperties)builder.addNodeType("TYPE_REF", "Reference to a type/class", schemaInfo).protoId(335)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeSchema.typeFullName()}));
            this.ret = (NodeType)((AbstractNodeType)builder.addNodeType("RETURN", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents a return instruction, e.g., `return x`. Note that it does\n            |NOT represent a formal return parameter as formal return parameters are\n            |represented via `METHOD_RETURN` nodes.\n            |")), schemaInfo).protoId(30)).starterName("ret");
            this.controlStructureType = (Property)builder.addProperty("CONTROL_STRUCTURE_TYPE", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The `CONTROL_STRUCTURE_TYPE` field indicates which kind of control structure\n            |a `CONTROL_STRUCTURE` node represents. The available types are the following:\n            | BREAK, CONTINUE, DO, WHILE, FOR, GOTO, IF, ELSE, TRY, THROW and SWITCH.\n            |")), schemaInfo).mandatory((Object)CpgSchema$PropertyDefaults$.MODULE$.String()).protoId(27);
            this.controlStructureTypes = builder.addConstants("ControlStructureTypes", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Constant[]{(Constant)Constant$.MODULE$.apply("BREAK", "BREAK", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Represents a break statement. Labeled breaks are expected to have a JUMP_LABEL\n            |node AST child with ORDER 1")), schemaInfo).protoId(1), (Constant)Constant$.MODULE$.apply("CONTINUE", "CONTINUE", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Represents a continue statement. Labeled continues are expected to have a JUMP_LABEL\n                           |node AST child with ORDER 1")), schemaInfo).protoId(2), (Constant)Constant$.MODULE$.apply("WHILE", "WHILE", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a while statement", schemaInfo).protoId(3), (Constant)Constant$.MODULE$.apply("DO", "DO", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a do statement", schemaInfo).protoId(4), (Constant)Constant$.MODULE$.apply("FOR", "FOR", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a for statement", schemaInfo).protoId(5), (Constant)Constant$.MODULE$.apply("GOTO", "GOTO", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a goto statement", schemaInfo).protoId(6), (Constant)Constant$.MODULE$.apply("IF", "IF", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents an if statement", schemaInfo).protoId(7), (Constant)Constant$.MODULE$.apply("ELSE", "ELSE", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents an else statement", schemaInfo).protoId(8), (Constant)Constant$.MODULE$.apply("SWITCH", "SWITCH", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a switch statement", schemaInfo).protoId(9), (Constant)Constant$.MODULE$.apply("TRY", "TRY", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a try statement", schemaInfo).protoId(10), (Constant)Constant$.MODULE$.apply("THROW", "THROW", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a throw statement", schemaInfo).protoId(11), (Constant)Constant$.MODULE$.apply("MATCH", "MATCH", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a match expression", schemaInfo).protoId(12), (Constant)Constant$.MODULE$.apply("YIELD", "YIELD", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Represents a yield expression", schemaInfo).protoId(13)}));
            this.controlStructure = (NodeType)((HasProperties)builder.addNodeType("CONTROL_STRUCTURE", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This node represents a control structure as introduced by control structure\n            |statements as well as conditional and unconditional jumps. Its type is stored in the\n            |`CONTROL_STRUCTURE_TYPE` field to be one of several pre-defined types. These types\n            | are used in the construction of the control flow layer, making it possible to\n            | generate the control flow layer from the abstract syntax tree layer automatically.\n            |\n            |In addition to the `CONTROL_STRUCTURE_TYPE` field, the `PARSER_TYPE_NAME` field\n            |MAY be used by frontends to store the name of the control structure as emitted by\n            |the parser or disassembler, however, the value of this field is not relevant\n            |for construction of the control flow layer.\n            |")), schemaInfo).protoId(339)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{base.parserTypeName(), this.controlStructureType()}));
            this.unknown = (NodeType)((HasProperties)builder.addNodeType("UNKNOWN", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Any AST node that the frontend would like to include in the AST but for\n            |which no suitable AST node is specified in the CPG specification may be\n            |included using a node of type `UNKNOWN`.\n            |")), schemaInfo).protoId(44)).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{base.parserTypeName(), typeSchema.typeFullName()}));
            this.ast = (EdgeType)builder.addEdgeType("AST", "This edge connects a parent node to its child in the syntax tree.", schemaInfo).protoId(3);
            this.condition = (EdgeType)builder.addEdgeType("CONDITION", "The edge connects control structure nodes to the expressions that holds their conditions.", schemaInfo).protoId(56);
            fs.file().addOutEdge(this.ast(), (AbstractNodeType)namespaces.namespaceBlock(), fs.file().addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, fs.file().addOutEdge$default$5(), fs.file().addOutEdge$default$6(), fs.file().addOutEdge$default$7(), fs.file().addOutEdge$default$8());
            typeSchema.member().addOutEdge(this.ast(), (AbstractNodeType)this.modifier(), typeSchema.member().addOutEdge$default$3(), typeSchema.member().addOutEdge$default$4(), typeSchema.member().addOutEdge$default$5(), typeSchema.member().addOutEdge$default$6(), typeSchema.member().addOutEdge$default$7(), typeSchema.member().addOutEdge$default$8());
            typeSchema.tpe().addOutEdge(this.ast(), (AbstractNodeType)typeSchema.typeArgument(), typeSchema.tpe().addOutEdge$default$3(), typeSchema.tpe().addOutEdge$default$4(), typeSchema.tpe().addOutEdge$default$5(), typeSchema.tpe().addOutEdge$default$6(), typeSchema.tpe().addOutEdge$default$7(), typeSchema.tpe().addOutEdge$default$8());
            NodeType nodeType = (NodeType)typeSchema.typeDecl().addOutEdge(this.ast(), (AbstractNodeType)typeSchema.typeParameter(), typeSchema.typeDecl().addOutEdge$default$3(), typeSchema.typeDecl().addOutEdge$default$4(), typeSchema.typeDecl().addOutEdge$default$5(), typeSchema.typeDecl().addOutEdge$default$6(), typeSchema.typeDecl().addOutEdge$default$7(), typeSchema.typeDecl().addOutEdge$default$8());
            NodeType nodeType2 = (NodeType)nodeType.addOutEdge(this.ast(), (AbstractNodeType)typeSchema.member(), nodeType.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, nodeType.addOutEdge$default$5(), nodeType.addOutEdge$default$6(), "typeDecl", "The type declaration this member is defined in");
            nodeType2.addOutEdge(this.ast(), (AbstractNodeType)this.modifier(), nodeType2.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, nodeType2.addOutEdge$default$5(), nodeType2.addOutEdge$default$6(), nodeType2.addOutEdge$default$7(), nodeType2.addOutEdge$default$8());
            NodeType nodeType3 = (NodeType)methodSchema.method().addOutEdge(this.ast(), (AbstractNodeType)methodSchema.methodReturn(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, "methodReturn", "Formal return parameters", methodSchema.method().addOutEdge$default$7(), methodSchema.method().addOutEdge$default$8());
            NodeType nodeType4 = (NodeType)nodeType3.addOutEdge(this.ast(), (AbstractNodeType)methodSchema.methodParameterIn(), nodeType3.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, "parameter", "Parameters of the method", "method", "Traverse to method associated with this formal parameter");
            NodeType nodeType5 = (NodeType)nodeType4.addOutEdge(this.ast(), (AbstractNodeType)this.modifier(), nodeType4.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, nodeType4.addOutEdge$default$5(), nodeType4.addOutEdge$default$6(), nodeType4.addOutEdge$default$7(), nodeType4.addOutEdge$default$8());
            NodeType nodeType6 = (NodeType)nodeType5.addOutEdge(this.ast(), (AbstractNodeType)this.block(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, "block", "Root of the abstract syntax tree", nodeType5.addOutEdge$default$7(), nodeType5.addOutEdge$default$8());
            nodeType6.addOutEdge(this.ast(), (AbstractNodeType)typeSchema.typeParameter(), nodeType6.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, nodeType6.addOutEdge$default$5(), nodeType6.addOutEdge$default$6(), nodeType6.addOutEdge$default$7(), nodeType6.addOutEdge$default$8());
            NodeType nodeType7 = (NodeType)this.ret().addOutEdge(this.ast(), (AbstractNodeType)this.identifier(), this.ret().addOutEdge$default$3(), this.ret().addOutEdge$default$4(), this.ret().addOutEdge$default$5(), this.ret().addOutEdge$default$6(), this.ret().addOutEdge$default$7(), this.ret().addOutEdge$default$8());
            NodeType nodeType8 = (NodeType)nodeType7.addOutEdge(this.ast(), (AbstractNodeType)this.literal(), nodeType7.addOutEdge$default$3(), nodeType7.addOutEdge$default$4(), nodeType7.addOutEdge$default$5(), nodeType7.addOutEdge$default$6(), nodeType7.addOutEdge$default$7(), nodeType7.addOutEdge$default$8());
            NodeType nodeType9 = (NodeType)nodeType8.addOutEdge(this.ast(), (AbstractNodeType)this.methodRef(), nodeType8.addOutEdge$default$3(), nodeType8.addOutEdge$default$4(), nodeType8.addOutEdge$default$5(), nodeType8.addOutEdge$default$6(), nodeType8.addOutEdge$default$7(), nodeType8.addOutEdge$default$8());
            NodeType nodeType10 = (NodeType)nodeType9.addOutEdge(this.ast(), (AbstractNodeType)this.typeRef(), nodeType9.addOutEdge$default$3(), nodeType9.addOutEdge$default$4(), nodeType9.addOutEdge$default$5(), nodeType9.addOutEdge$default$6(), nodeType9.addOutEdge$default$7(), nodeType9.addOutEdge$default$8());
            NodeType nodeType11 = (NodeType)nodeType10.addOutEdge(this.ast(), (AbstractNodeType)this.ret(), nodeType10.addOutEdge$default$3(), nodeType10.addOutEdge$default$4(), nodeType10.addOutEdge$default$5(), nodeType10.addOutEdge$default$6(), nodeType10.addOutEdge$default$7(), nodeType10.addOutEdge$default$8());
            NodeType nodeType12 = (NodeType)nodeType11.addOutEdge(this.ast(), (AbstractNodeType)this.block(), nodeType11.addOutEdge$default$3(), nodeType11.addOutEdge$default$4(), nodeType11.addOutEdge$default$5(), nodeType11.addOutEdge$default$6(), nodeType11.addOutEdge$default$7(), nodeType11.addOutEdge$default$8());
            NodeType nodeType13 = (NodeType)nodeType12.addOutEdge(this.ast(), (AbstractNodeType)this.unknown(), nodeType12.addOutEdge$default$3(), nodeType12.addOutEdge$default$4(), nodeType12.addOutEdge$default$5(), nodeType12.addOutEdge$default$6(), nodeType12.addOutEdge$default$7(), nodeType12.addOutEdge$default$8());
            NodeType nodeType14 = (NodeType)nodeType13.addOutEdge(this.ast(), (AbstractNodeType)this.jumpTarget(), nodeType13.addOutEdge$default$3(), nodeType13.addOutEdge$default$4(), nodeType13.addOutEdge$default$5(), nodeType13.addOutEdge$default$6(), nodeType13.addOutEdge$default$7(), nodeType13.addOutEdge$default$8());
            nodeType14.addOutEdge(this.ast(), (AbstractNodeType)this.controlStructure(), nodeType14.addOutEdge$default$3(), nodeType14.addOutEdge$default$4(), nodeType14.addOutEdge$default$5(), nodeType14.addOutEdge$default$6(), nodeType14.addOutEdge$default$7(), nodeType14.addOutEdge$default$8());
            NodeType nodeType15 = (NodeType)this.block().addOutEdge(this.ast(), (AbstractNodeType)this.identifier(), this.block().addOutEdge$default$3(), this.block().addOutEdge$default$4(), this.block().addOutEdge$default$5(), this.block().addOutEdge$default$6(), this.block().addOutEdge$default$7(), this.block().addOutEdge$default$8());
            NodeType nodeType16 = (NodeType)nodeType15.addOutEdge(this.ast(), (AbstractNodeType)this.literal(), nodeType15.addOutEdge$default$3(), nodeType15.addOutEdge$default$4(), nodeType15.addOutEdge$default$5(), nodeType15.addOutEdge$default$6(), nodeType15.addOutEdge$default$7(), nodeType15.addOutEdge$default$8());
            NodeType nodeType17 = (NodeType)nodeType16.addOutEdge(this.ast(), (AbstractNodeType)this.methodRef(), nodeType16.addOutEdge$default$3(), nodeType16.addOutEdge$default$4(), nodeType16.addOutEdge$default$5(), nodeType16.addOutEdge$default$6(), nodeType16.addOutEdge$default$7(), nodeType16.addOutEdge$default$8());
            NodeType nodeType18 = (NodeType)nodeType17.addOutEdge(this.ast(), (AbstractNodeType)this.typeRef(), nodeType17.addOutEdge$default$3(), nodeType17.addOutEdge$default$4(), nodeType17.addOutEdge$default$5(), nodeType17.addOutEdge$default$6(), nodeType17.addOutEdge$default$7(), nodeType17.addOutEdge$default$8());
            NodeType nodeType19 = (NodeType)nodeType18.addOutEdge(this.ast(), (AbstractNodeType)this.ret(), nodeType18.addOutEdge$default$3(), nodeType18.addOutEdge$default$4(), nodeType18.addOutEdge$default$5(), nodeType18.addOutEdge$default$6(), nodeType18.addOutEdge$default$7(), nodeType18.addOutEdge$default$8());
            NodeType nodeType20 = (NodeType)nodeType19.addOutEdge(this.ast(), (AbstractNodeType)this.block(), nodeType19.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, nodeType19.addOutEdge$default$5(), nodeType19.addOutEdge$default$6(), nodeType19.addOutEdge$default$7(), nodeType19.addOutEdge$default$8());
            NodeType nodeType21 = (NodeType)nodeType20.addOutEdge(this.ast(), (AbstractNodeType)this.local(), nodeType20.addOutEdge$default$3(), nodeType20.addOutEdge$default$4(), "local", "Traverse to locals of this block.", "definingBlock", "The block in which local is declared.");
            NodeType nodeType22 = (NodeType)nodeType21.addOutEdge(this.ast(), (AbstractNodeType)this.unknown(), nodeType21.addOutEdge$default$3(), nodeType21.addOutEdge$default$4(), nodeType21.addOutEdge$default$5(), nodeType21.addOutEdge$default$6(), nodeType21.addOutEdge$default$7(), nodeType21.addOutEdge$default$8());
            NodeType nodeType23 = (NodeType)nodeType22.addOutEdge(this.ast(), (AbstractNodeType)this.jumpTarget(), nodeType22.addOutEdge$default$3(), nodeType22.addOutEdge$default$4(), nodeType22.addOutEdge$default$5(), nodeType22.addOutEdge$default$6(), nodeType22.addOutEdge$default$7(), nodeType22.addOutEdge$default$8());
            nodeType23.addOutEdge(this.ast(), (AbstractNodeType)this.controlStructure(), nodeType23.addOutEdge$default$3(), nodeType23.addOutEdge$default$4(), nodeType23.addOutEdge$default$5(), nodeType23.addOutEdge$default$6(), nodeType23.addOutEdge$default$7(), nodeType23.addOutEdge$default$8());
            NodeType nodeType24 = (NodeType)this.controlStructure().addOutEdge(this.ast(), (AbstractNodeType)this.literal(), this.controlStructure().addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, this.controlStructure().addOutEdge$default$5(), this.controlStructure().addOutEdge$default$6(), this.controlStructure().addOutEdge$default$7(), this.controlStructure().addOutEdge$default$8());
            NodeType nodeType25 = (NodeType)nodeType24.addOutEdge(this.ast(), (AbstractNodeType)this.modifier(), nodeType24.addOutEdge$default$3(), nodeType24.addOutEdge$default$4(), nodeType24.addOutEdge$default$5(), nodeType24.addOutEdge$default$6(), nodeType24.addOutEdge$default$7(), nodeType24.addOutEdge$default$8());
            NodeType nodeType26 = (NodeType)nodeType25.addOutEdge(this.ast(), (AbstractNodeType)this.local(), nodeType25.addOutEdge$default$3(), nodeType25.addOutEdge$default$4(), nodeType25.addOutEdge$default$5(), nodeType25.addOutEdge$default$6(), nodeType25.addOutEdge$default$7(), nodeType25.addOutEdge$default$8());
            NodeType nodeType27 = (NodeType)nodeType26.addOutEdge(this.ast(), (AbstractNodeType)this.identifier(), nodeType26.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType26.addOutEdge$default$5(), nodeType26.addOutEdge$default$6(), nodeType26.addOutEdge$default$7(), nodeType26.addOutEdge$default$8());
            NodeType nodeType28 = (NodeType)nodeType27.addOutEdge(this.ast(), (AbstractNodeType)this.ret(), nodeType27.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType27.addOutEdge$default$5(), nodeType27.addOutEdge$default$6(), nodeType27.addOutEdge$default$7(), nodeType27.addOutEdge$default$8());
            NodeType nodeType29 = (NodeType)nodeType28.addOutEdge(this.ast(), (AbstractNodeType)this.block(), nodeType28.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType28.addOutEdge$default$5(), nodeType28.addOutEdge$default$6(), nodeType28.addOutEdge$default$7(), nodeType28.addOutEdge$default$8());
            NodeType nodeType30 = (NodeType)nodeType29.addOutEdge(this.ast(), (AbstractNodeType)this.jumpTarget(), nodeType29.addOutEdge$default$3(), nodeType29.addOutEdge$default$4(), nodeType29.addOutEdge$default$5(), nodeType29.addOutEdge$default$6(), nodeType29.addOutEdge$default$7(), nodeType29.addOutEdge$default$8());
            NodeType nodeType31 = (NodeType)nodeType30.addOutEdge(this.ast(), (AbstractNodeType)this.unknown(), nodeType30.addOutEdge$default$3(), nodeType30.addOutEdge$default$4(), nodeType30.addOutEdge$default$5(), nodeType30.addOutEdge$default$6(), nodeType30.addOutEdge$default$7(), nodeType30.addOutEdge$default$8());
            NodeType nodeType32 = (NodeType)nodeType31.addOutEdge(this.ast(), (AbstractNodeType)this.controlStructure(), nodeType31.addOutEdge$default$3(), nodeType31.addOutEdge$default$4(), nodeType31.addOutEdge$default$5(), nodeType31.addOutEdge$default$6(), nodeType31.addOutEdge$default$7(), nodeType31.addOutEdge$default$8());
            NodeType nodeType33 = (NodeType)nodeType32.addOutEdge(this.ast(), (AbstractNodeType)this.methodRef(), nodeType32.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, nodeType32.addOutEdge$default$5(), nodeType32.addOutEdge$default$6(), nodeType32.addOutEdge$default$7(), nodeType32.addOutEdge$default$8());
            NodeType nodeType34 = (NodeType)nodeType33.addOutEdge(this.ast(), (AbstractNodeType)this.typeRef(), nodeType33.addOutEdge$default$3(), nodeType33.addOutEdge$default$4(), nodeType33.addOutEdge$default$5(), nodeType33.addOutEdge$default$6(), nodeType33.addOutEdge$default$7(), nodeType33.addOutEdge$default$8());
            nodeType34.addOutEdge(this.ast(), (AbstractNodeType)this.jumpLabel(), nodeType34.addOutEdge$default$3(), nodeType34.addOutEdge$default$4(), nodeType34.addOutEdge$default$5(), nodeType34.addOutEdge$default$6(), nodeType34.addOutEdge$default$7(), nodeType34.addOutEdge$default$8());
            NodeType nodeType35 = (NodeType)this.unknown().addOutEdge(this.ast(), (AbstractNodeType)this.literal(), this.unknown().addOutEdge$default$3(), this.unknown().addOutEdge$default$4(), this.unknown().addOutEdge$default$5(), this.unknown().addOutEdge$default$6(), this.unknown().addOutEdge$default$7(), this.unknown().addOutEdge$default$8());
            NodeType nodeType36 = (NodeType)nodeType35.addOutEdge(this.ast(), (AbstractNodeType)this.modifier(), nodeType35.addOutEdge$default$3(), nodeType35.addOutEdge$default$4(), nodeType35.addOutEdge$default$5(), nodeType35.addOutEdge$default$6(), nodeType35.addOutEdge$default$7(), nodeType35.addOutEdge$default$8());
            NodeType nodeType37 = (NodeType)nodeType36.addOutEdge(this.ast(), (AbstractNodeType)this.local(), nodeType36.addOutEdge$default$3(), nodeType36.addOutEdge$default$4(), nodeType36.addOutEdge$default$5(), nodeType36.addOutEdge$default$6(), nodeType36.addOutEdge$default$7(), nodeType36.addOutEdge$default$8());
            NodeType nodeType38 = (NodeType)nodeType37.addOutEdge(this.ast(), (AbstractNodeType)this.identifier(), nodeType37.addOutEdge$default$3(), nodeType37.addOutEdge$default$4(), nodeType37.addOutEdge$default$5(), nodeType37.addOutEdge$default$6(), nodeType37.addOutEdge$default$7(), nodeType37.addOutEdge$default$8());
            NodeType nodeType39 = (NodeType)nodeType38.addOutEdge(this.ast(), (AbstractNodeType)this.fieldIdentifier(), nodeType38.addOutEdge$default$3(), nodeType38.addOutEdge$default$4(), nodeType38.addOutEdge$default$5(), nodeType38.addOutEdge$default$6(), nodeType38.addOutEdge$default$7(), nodeType38.addOutEdge$default$8());
            NodeType nodeType40 = (NodeType)nodeType39.addOutEdge(this.ast(), (AbstractNodeType)this.ret(), nodeType39.addOutEdge$default$3(), nodeType39.addOutEdge$default$4(), nodeType39.addOutEdge$default$5(), nodeType39.addOutEdge$default$6(), nodeType39.addOutEdge$default$7(), nodeType39.addOutEdge$default$8());
            NodeType nodeType41 = (NodeType)nodeType40.addOutEdge(this.ast(), (AbstractNodeType)this.block(), nodeType40.addOutEdge$default$3(), nodeType40.addOutEdge$default$4(), nodeType40.addOutEdge$default$5(), nodeType40.addOutEdge$default$6(), nodeType40.addOutEdge$default$7(), nodeType40.addOutEdge$default$8());
            NodeType nodeType42 = (NodeType)nodeType41.addOutEdge(this.ast(), (AbstractNodeType)this.jumpTarget(), nodeType41.addOutEdge$default$3(), nodeType41.addOutEdge$default$4(), nodeType41.addOutEdge$default$5(), nodeType41.addOutEdge$default$6(), nodeType41.addOutEdge$default$7(), nodeType41.addOutEdge$default$8());
            NodeType nodeType43 = (NodeType)nodeType42.addOutEdge(this.ast(), (AbstractNodeType)this.unknown(), nodeType42.addOutEdge$default$3(), nodeType42.addOutEdge$default$4(), nodeType42.addOutEdge$default$5(), nodeType42.addOutEdge$default$6(), nodeType42.addOutEdge$default$7(), nodeType42.addOutEdge$default$8());
            nodeType43.addOutEdge(this.ast(), (AbstractNodeType)this.controlStructure(), nodeType43.addOutEdge$default$3(), nodeType43.addOutEdge$default$4(), nodeType43.addOutEdge$default$5(), nodeType43.addOutEdge$default$6(), nodeType43.addOutEdge$default$7(), nodeType43.addOutEdge$default$8());
            this.unknown().addOutEdge(this.ast(), (AbstractNodeType)typeSchema.member(), this.unknown().addOutEdge$default$3(), this.unknown().addOutEdge$default$4(), this.unknown().addOutEdge$default$5(), this.unknown().addOutEdge$default$6(), this.unknown().addOutEdge$default$7(), this.unknown().addOutEdge$default$8());
            methodSchema.methodParameterIn().addOutEdge(this.ast(), (AbstractNodeType)this.unknown(), methodSchema.methodParameterIn().addOutEdge$default$3(), methodSchema.methodParameterIn().addOutEdge$default$4(), methodSchema.methodParameterIn().addOutEdge$default$5(), methodSchema.methodParameterIn().addOutEdge$default$6(), methodSchema.methodParameterIn().addOutEdge$default$7(), methodSchema.methodParameterIn().addOutEdge$default$8());
            NodeType nodeType44 = (NodeType)namespaces.namespaceBlock().addOutEdge(this.ast(), (AbstractNodeType)typeSchema.typeDecl(), namespaces.namespaceBlock().addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, namespaces.namespaceBlock().addOutEdge$default$5(), namespaces.namespaceBlock().addOutEdge$default$6(), "namespaceBlock", namespaces.namespaceBlock().addOutEdge$default$8());
            nodeType44.addOutEdge(this.ast(), (AbstractNodeType)methodSchema.method(), nodeType44.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType44.addOutEdge$default$5(), nodeType44.addOutEdge$default$6(), nodeType44.addOutEdge$default$7(), nodeType44.addOutEdge$default$8());
            namespaces.namespace().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            NodeType nodeType45 = (NodeType)this.controlStructure().addOutEdge(this.condition(), (AbstractNodeType)this.literal(), this.controlStructure().addOutEdge$default$3(), this.controlStructure().addOutEdge$default$4(), this.controlStructure().addOutEdge$default$5(), this.controlStructure().addOutEdge$default$6(), this.controlStructure().addOutEdge$default$7(), this.controlStructure().addOutEdge$default$8());
            NodeType nodeType46 = (NodeType)nodeType45.addOutEdge(this.condition(), (AbstractNodeType)this.identifier(), nodeType45.addOutEdge$default$3(), nodeType45.addOutEdge$default$4(), nodeType45.addOutEdge$default$5(), nodeType45.addOutEdge$default$6(), nodeType45.addOutEdge$default$7(), nodeType45.addOutEdge$default$8());
            NodeType nodeType47 = (NodeType)nodeType46.addOutEdge(this.condition(), (AbstractNodeType)this.ret(), nodeType46.addOutEdge$default$3(), nodeType46.addOutEdge$default$4(), nodeType46.addOutEdge$default$5(), nodeType46.addOutEdge$default$6(), nodeType46.addOutEdge$default$7(), nodeType46.addOutEdge$default$8());
            NodeType nodeType48 = (NodeType)nodeType47.addOutEdge(this.condition(), (AbstractNodeType)this.block(), nodeType47.addOutEdge$default$3(), nodeType47.addOutEdge$default$4(), nodeType47.addOutEdge$default$5(), nodeType47.addOutEdge$default$6(), nodeType47.addOutEdge$default$7(), nodeType47.addOutEdge$default$8());
            NodeType nodeType49 = (NodeType)nodeType48.addOutEdge(this.condition(), (AbstractNodeType)this.methodRef(), nodeType48.addOutEdge$default$3(), nodeType48.addOutEdge$default$4(), nodeType48.addOutEdge$default$5(), nodeType48.addOutEdge$default$6(), nodeType48.addOutEdge$default$7(), nodeType48.addOutEdge$default$8());
            NodeType nodeType50 = (NodeType)nodeType49.addOutEdge(this.condition(), (AbstractNodeType)this.typeRef(), nodeType49.addOutEdge$default$3(), nodeType49.addOutEdge$default$4(), nodeType49.addOutEdge$default$5(), nodeType49.addOutEdge$default$6(), nodeType49.addOutEdge$default$7(), nodeType49.addOutEdge$default$8());
            NodeType nodeType51 = (NodeType)nodeType50.addOutEdge(this.condition(), (AbstractNodeType)this.controlStructure(), nodeType50.addOutEdge$default$3(), nodeType50.addOutEdge$default$4(), nodeType50.addOutEdge$default$5(), nodeType50.addOutEdge$default$6(), nodeType50.addOutEdge$default$7(), nodeType50.addOutEdge$default$8());
            NodeType nodeType52 = (NodeType)nodeType51.addOutEdge(this.condition(), (AbstractNodeType)this.jumpTarget(), nodeType51.addOutEdge$default$3(), nodeType51.addOutEdge$default$4(), nodeType51.addOutEdge$default$5(), nodeType51.addOutEdge$default$6(), nodeType51.addOutEdge$default$7(), nodeType51.addOutEdge$default$8());
            NodeType nodeType53 = (NodeType)nodeType52.addOutEdge(this.condition(), (AbstractNodeType)this.unknown(), nodeType52.addOutEdge$default$3(), nodeType52.addOutEdge$default$4(), nodeType52.addOutEdge$default$5(), nodeType52.addOutEdge$default$6(), nodeType52.addOutEdge$default$7(), nodeType52.addOutEdge$default$8());
            nodeType53.addOutEdge(this.condition(), (AbstractNodeType)this.controlStructure(), nodeType53.addOutEdge$default$3(), nodeType53.addOutEdge$default$4(), nodeType53.addOutEdge$default$5(), nodeType53.addOutEdge$default$6(), nodeType53.addOutEdge$default$7(), nodeType53.addOutEdge$default$8());
            NodeType nodeType54 = (NodeType)typeSchema.typeDecl().addOutEdge(this.ast(), (AbstractNodeType)typeSchema.typeDecl(), typeSchema.typeDecl().addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, typeSchema.typeDecl().addOutEdge$default$5(), typeSchema.typeDecl().addOutEdge$default$6(), typeSchema.typeDecl().addOutEdge$default$7(), typeSchema.typeDecl().addOutEdge$default$8());
            nodeType54.addOutEdge(this.ast(), (AbstractNodeType)methodSchema.method(), nodeType54.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType54.addOutEdge$default$5(), nodeType54.addOutEdge$default$6(), nodeType54.addOutEdge$default$7(), nodeType54.addOutEdge$default$8());
            NodeType nodeType55 = (NodeType)methodSchema.method().addOutEdge(this.ast(), (AbstractNodeType)methodSchema.methodParameterOut(), methodSchema.method().addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, methodSchema.method().addOutEdge$default$5(), methodSchema.method().addOutEdge$default$6(), "method", methodSchema.method().addOutEdge$default$8());
            NodeType nodeType56 = (NodeType)nodeType55.addOutEdge(this.ast(), (AbstractNodeType)typeSchema.typeDecl(), nodeType55.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType55.addOutEdge$default$5(), nodeType55.addOutEdge$default$6(), nodeType55.addOutEdge$default$7(), nodeType55.addOutEdge$default$8());
            nodeType56.addOutEdge(this.ast(), (AbstractNodeType)methodSchema.method(), nodeType56.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType56.addOutEdge$default$5(), nodeType56.addOutEdge$default$6(), nodeType56.addOutEdge$default$7(), nodeType56.addOutEdge$default$8());
            this.callRepr = (NodeBaseType)builder.addNodeBaseType("CALL_REPR", "This is the base class of `CALL` that language implementers may safely ignore.", schemaInfo).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{base.name(), methodSchema.signature()}));
            this.callNode = (NodeType)((AbstractNodeType)builder.addNodeType("CALL", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A (function/method/procedure) call. The `METHOD_FULL_NAME` property is the name of the\n                    |invoked method (the callee) while the `TYPE_FULL_NAME` is its return type, and\n                    |therefore, the return type of the call when viewing it as an expression. For\n                    |languages like Javascript, it is common that we may know the (short-) name\n                    |of the invoked method, but we do not know at compile time which method\n                    |will actually be invoked, e.g., because it depends on a dynamic import.\n                    |In this case, we leave `METHOD_FULL_NAME` blank but at least fill out `NAME`,\n                    |which contains the method's (short-) name and `SIGNATURE`, which contains\n                    |any information we may have about the types of arguments and return value.\n                    |")), schemaInfo).protoId(15)).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.callRepr()})).addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{typeSchema.typeFullName()}));
            this.expression = (NodeBaseType)builder.addNodeBaseType("EXPRESSION", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("`EXPRESSION` is the base class for all nodes that represent code pieces\n                    |that can be evaluated.\n                    |\n                    | Expression may be arguments in method calls. For method calls that do\n                    | not involved named parameters, the `ARGUMENT_INDEX` field indicates at\n                    | which position in the argument list the expression occurs, e.g., an\n                    | `ARGUMENT_INDEX` of 1 indicates that the expression is the first argument\n                    | in a method call. For calls that employ named parameters, `ARGUMENT_INDEX`\n                    | is set to -1 and the `ARGUMENT_NAME` fields holds the name of the parameter.\n                    |")), schemaInfo).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.astNode()}));
            this.fieldIdentifier().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            this.identifier().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            this.literal().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            this.block().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            this.controlStructure().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            this.methodRef().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            this.typeRef().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            this.ret().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            this.unknown().extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{this.expression()}));
            NodeType nodeType57 = (NodeType)this.callNode().addOutEdge(this.ast(), (AbstractNodeType)this.callNode(), this.callNode().addOutEdge$default$3(), this.callNode().addOutEdge$default$4(), this.callNode().addOutEdge$default$5(), this.callNode().addOutEdge$default$6(), this.callNode().addOutEdge$default$7(), this.callNode().addOutEdge$default$8());
            NodeType nodeType58 = (NodeType)nodeType57.addOutEdge(this.ast(), (AbstractNodeType)this.identifier(), nodeType57.addOutEdge$default$3(), nodeType57.addOutEdge$default$4(), nodeType57.addOutEdge$default$5(), nodeType57.addOutEdge$default$6(), nodeType57.addOutEdge$default$7(), nodeType57.addOutEdge$default$8());
            NodeType nodeType59 = (NodeType)nodeType58.addOutEdge(this.ast(), (AbstractNodeType)this.fieldIdentifier(), nodeType58.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, nodeType58.addOutEdge$default$5(), nodeType58.addOutEdge$default$6(), nodeType58.addOutEdge$default$7(), nodeType58.addOutEdge$default$8());
            NodeType nodeType60 = (NodeType)nodeType59.addOutEdge(this.ast(), (AbstractNodeType)this.literal(), nodeType59.addOutEdge$default$3(), nodeType59.addOutEdge$default$4(), nodeType59.addOutEdge$default$5(), nodeType59.addOutEdge$default$6(), nodeType59.addOutEdge$default$7(), nodeType59.addOutEdge$default$8());
            NodeType nodeType61 = (NodeType)nodeType60.addOutEdge(this.ast(), (AbstractNodeType)this.methodRef(), nodeType60.addOutEdge$default$3(), nodeType60.addOutEdge$default$4(), nodeType60.addOutEdge$default$5(), nodeType60.addOutEdge$default$6(), nodeType60.addOutEdge$default$7(), nodeType60.addOutEdge$default$8());
            NodeType nodeType62 = (NodeType)nodeType61.addOutEdge(this.ast(), (AbstractNodeType)this.typeRef(), nodeType61.addOutEdge$default$3(), nodeType61.addOutEdge$default$4(), nodeType61.addOutEdge$default$5(), nodeType61.addOutEdge$default$6(), nodeType61.addOutEdge$default$7(), nodeType61.addOutEdge$default$8());
            NodeType nodeType63 = (NodeType)nodeType62.addOutEdge(this.ast(), (AbstractNodeType)this.ret(), nodeType62.addOutEdge$default$3(), nodeType62.addOutEdge$default$4(), nodeType62.addOutEdge$default$5(), nodeType62.addOutEdge$default$6(), nodeType62.addOutEdge$default$7(), nodeType62.addOutEdge$default$8());
            NodeType nodeType64 = (NodeType)nodeType63.addOutEdge(this.ast(), (AbstractNodeType)this.block(), nodeType63.addOutEdge$default$3(), nodeType63.addOutEdge$default$4(), nodeType63.addOutEdge$default$5(), nodeType63.addOutEdge$default$6(), nodeType63.addOutEdge$default$7(), nodeType63.addOutEdge$default$8());
            nodeType64.addOutEdge(this.ast(), (AbstractNodeType)this.controlStructure(), nodeType64.addOutEdge$default$3(), nodeType64.addOutEdge$default$4(), nodeType64.addOutEdge$default$5(), nodeType64.addOutEdge$default$6(), nodeType64.addOutEdge$default$7(), nodeType64.addOutEdge$default$8());
            this.ret().addOutEdge(this.ast(), (AbstractNodeType)this.callNode(), this.ret().addOutEdge$default$3(), this.ret().addOutEdge$default$4(), this.ret().addOutEdge$default$5(), this.ret().addOutEdge$default$6(), this.ret().addOutEdge$default$7(), this.ret().addOutEdge$default$8());
            this.controlStructure().addOutEdge(this.ast(), (AbstractNodeType)this.callNode(), this.controlStructure().addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, this.controlStructure().addOutEdge$default$5(), this.controlStructure().addOutEdge$default$6(), this.controlStructure().addOutEdge$default$7(), this.controlStructure().addOutEdge$default$8());
            this.unknown().addOutEdge(this.ast(), (AbstractNodeType)this.callNode(), this.unknown().addOutEdge$default$3(), this.unknown().addOutEdge$default$4(), this.unknown().addOutEdge$default$5(), this.unknown().addOutEdge$default$6(), this.unknown().addOutEdge$default$7(), this.unknown().addOutEdge$default$8());
            this.controlStructure().addOutEdge(this.condition(), (AbstractNodeType)this.callNode(), this.controlStructure().addOutEdge$default$3(), this.controlStructure().addOutEdge$default$4(), this.controlStructure().addOutEdge$default$5(), this.controlStructure().addOutEdge$default$6(), this.controlStructure().addOutEdge$default$7(), this.controlStructure().addOutEdge$default$8());
            this.block().addOutEdge(this.ast(), (AbstractNodeType)this.callNode(), this.block().addOutEdge$default$3(), this.block().addOutEdge$default$4(), this.block().addOutEdge$default$5(), this.block().addOutEdge$default$6(), this.block().addOutEdge$default$7(), this.block().addOutEdge$default$8());
            NodeType nodeType65 = (NodeType)this.identifier().addOutEdge(base.ref(), (AbstractNodeType)this.local(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, this.identifier().addOutEdge$default$4(), this.identifier().addOutEdge$default$5(), this.identifier().addOutEdge$default$6(), "referencingIdentifiers", "Places (identifier) where this local is being referenced");
            nodeType65.addOutEdge(base.ref(), (AbstractNodeType)methodSchema.methodParameterIn(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType65.addOutEdge$default$4(), nodeType65.addOutEdge$default$5(), nodeType65.addOutEdge$default$6(), "referencingIdentifiers", "Places (identifier) where this parameter is being referenced");
            namespaces.namespaceBlock().addOutEdge(base.ref(), (AbstractNodeType)namespaces.namespace(), namespaces.namespaceBlock().addOutEdge$default$3(), namespaces.namespaceBlock().addOutEdge$default$4(), namespaces.namespaceBlock().addOutEdge$default$5(), namespaces.namespaceBlock().addOutEdge$default$6(), namespaces.namespaceBlock().addOutEdge$default$7(), namespaces.namespaceBlock().addOutEdge$default$8());
        }

        public Property<Object> order() {
            return this.order;
        }

        public NodeBaseType astNode() {
            return this.astNode;
        }

        public NodeType block() {
            return this.block;
        }

        public NodeType literal() {
            return this.literal;
        }

        public NodeType local() {
            return this.local;
        }

        public NodeType identifier() {
            return this.identifier;
        }

        public Property<String> canonicalName() {
            return this.canonicalName;
        }

        public NodeType fieldIdentifier() {
            return this.fieldIdentifier;
        }

        public Property<String> modifierType() {
            return this.modifierType;
        }

        public Seq<Constant<?>> modifierTypes() {
            return this.modifierTypes;
        }

        public NodeType modifier() {
            return this.modifier;
        }

        public NodeType jumpTarget() {
            return this.jumpTarget;
        }

        public NodeType jumpLabel() {
            return this.jumpLabel;
        }

        public NodeType methodRef() {
            return this.methodRef;
        }

        public NodeType typeRef() {
            return this.typeRef;
        }

        public NodeType ret() {
            return this.ret;
        }

        public Property<String> controlStructureType() {
            return this.controlStructureType;
        }

        public Seq<Constant<?>> controlStructureTypes() {
            return this.controlStructureTypes;
        }

        public NodeType controlStructure() {
            return this.controlStructure;
        }

        public NodeType unknown() {
            return this.unknown;
        }

        public EdgeType ast() {
            return this.ast;
        }

        public EdgeType condition() {
            return this.condition;
        }

        public NodeBaseType callRepr() {
            return this.callRepr;
        }

        public NodeType callNode() {
            return this.callNode;
        }

        public NodeBaseType expression() {
            return this.expression;
        }
    }
}

