/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.schema;

import io.shiftleft.codepropertygraph.schema.Ast;
import io.shiftleft.codepropertygraph.schema.CallGraph$;
import io.shiftleft.codepropertygraph.schema.CpgSchema$PropertyDefaults$;
import io.shiftleft.codepropertygraph.schema.Method;
import overflowdb.schema.AbstractNodeType;
import overflowdb.schema.Constant;
import overflowdb.schema.Constant$;
import overflowdb.schema.EdgeType;
import overflowdb.schema.NodeBaseType;
import overflowdb.schema.NodeType;
import overflowdb.schema.Property;
import overflowdb.schema.SchemaBuilder;
import overflowdb.schema.SchemaInfo;
import overflowdb.schema.SchemaInfo$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CallGraph {
    public static Schema apply(SchemaBuilder schemaBuilder, Method.Schema schema, Ast.Schema schema2) {
        return CallGraph$.MODULE$.apply(schemaBuilder, schema, schema2);
    }

    public static String description() {
        return CallGraph$.MODULE$.description();
    }

    public static int docIndex() {
        return CallGraph$.MODULE$.docIndex();
    }

    public static boolean providedByFrontend() {
        return CallGraph$.MODULE$.providedByFrontend();
    }

    public static class Schema {
        private final Property argumentIndex;
        private final Property argumentName;
        private final Property methodFullName;
        private final Property evaluationStrategy;
        private final Seq evaluationStrategies;
        private final Property dispatchType;
        private final EdgeType call;
        private final EdgeType argument;
        private final EdgeType receiver;
        private final Seq dispatchTypes;

        public Schema(SchemaBuilder builder, Method.Schema methodSchema, Ast.Schema astSchema) {
            SchemaInfo schemaInfo = SchemaInfo$.MODULE$.forClass(this.getClass());
            this.argumentIndex = (Property)builder.addProperty("ARGUMENT_INDEX", (Property.ValueType)Property.ValueType$.Int$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("AST-children of CALL nodes have an argument index, that is used to match\n                    |call-site arguments with callee parameters. Explicit parameters are numbered\n                    |from 1 to N, while index 0 is reserved for implicit self / this parameter.\n                    |CALLs without implicit parameter therefore have arguments starting with index 1.\n                    |AST-children of BLOCK nodes may have an argument index as well; in this case,\n                    |the last argument index determines the return expression of a BLOCK expression.\n                    |If the `PARAMETER_NAME` field is set, then the `ARGUMENT_INDEX` field is\n                    |ignored. It is suggested to set it to -1.\n                    |")), schemaInfo).mandatory((Object)BoxesRunTime.boxToInteger((int)-1)).protoId(40);
            this.argumentName = (Property)builder.addProperty("ARGUMENT_NAME", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |For calls involving named parameters, the `ARGUMENT_NAME` field holds the\n            |name of the parameter initialized by the expression. For all other calls,\n            |this field is unset.\n            |")), schemaInfo).protoId(130);
            this.methodFullName = (Property)builder.addProperty("METHOD_FULL_NAME", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("The FULL_NAME of a method. Used to link CALL and METHOD nodes. It is required\n                    |to have exactly one METHOD node for each METHOD_FULL_NAME")), schemaInfo).mandatory((Object)CpgSchema$PropertyDefaults$.MODULE$.String()).protoId(54);
            astSchema.expression().addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{this.argumentIndex(), this.argumentName()}));
            this.evaluationStrategy = (Property)builder.addProperty("EVALUATION_STRATEGY", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("For formal method input parameters, output parameters, and return parameters,\n            |this field holds the evaluation strategy, which is one of the following:\n            |1) `BY_REFERENCE` indicates that the parameter is passed by reference, 2)\n            |`BY_VALUE` indicates that it is passed by value, that is, a copy is made,\n            |3) `BY_SHARING` the parameter is a pointer/reference and it is shared with\n            |the caller/callee. While a copy of the pointer is made, a copy of the object\n            |that it points to is not made.\n            |")), schemaInfo).mandatory((Object)CpgSchema$PropertyDefaults$.MODULE$.String()).protoId(15);
            this.evaluationStrategies = builder.addConstants("EvaluationStrategies", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Constant[]{(Constant)Constant$.MODULE$.apply("BY_REFERENCE", "BY_REFERENCE", (Property.ValueType)Property.ValueType$.String$.MODULE$, "A parameter or return of a function is passed by reference which means an address is used behind the scenes", schemaInfo).protoId(1), (Constant)Constant$.MODULE$.apply("BY_SHARING", "BY_SHARING", (Property.ValueType)Property.ValueType$.String$.MODULE$, "Only applicable to object parameter or return values. The pointer to the object is passed by value but the object itself is not copied and changes to it are thus propagated out of the method context", schemaInfo).protoId(2), (Constant)Constant$.MODULE$.apply("BY_VALUE", "BY_VALUE", (Property.ValueType)Property.ValueType$.String$.MODULE$, "A parameter or return of a function passed by value which means a flat copy is used", schemaInfo).protoId(3)}));
            methodSchema.methodParameterIn().addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{this.evaluationStrategy()}));
            methodSchema.methodReturn().addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{this.evaluationStrategy()}));
            methodSchema.methodParameterOut().addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{this.evaluationStrategy()}));
            this.dispatchType = (Property)builder.addProperty("DISPATCH_TYPE", (Property.ValueType)Property.ValueType$.String$.MODULE$, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This field holds the dispatch type of a call, which is either `STATIC_DISPATCH` or\n            |`DYNAMIC_DISPATCH`. For statically dispatched method calls, the call target is known\n            |at compile time while for dynamically dispatched calls, it can only be determined at\n            |runtime as it may depend on the type of an object (as is the case for virtual method\n            |calls) or calculation of an offset.\n            |")), schemaInfo).mandatory((Object)CpgSchema$PropertyDefaults$.MODULE$.String()).protoId(25);
            this.call = (EdgeType)builder.addEdgeType("CALL", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("This edge connects call sites, i.e., nodes with the type `CALL`, to the\n            |method node that represent the method they invoke. The frontend MAY create\n            |`CALL` edges but is not required to do so. Instead, of the `METHOD_FULL_NAME`\n            |field of the `CALL` node is set correctly, `CALL` edges are created\n            |automatically as the CPG is first loaded.\n            |")), schemaInfo).protoId(6);
            this.argument = (EdgeType)builder.addEdgeType("ARGUMENT", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Argument edges connect call sites (node type `CALL`) to their arguments\n            |(node type `EXPRESSION`) as well as `RETURN` nodes to the expressions\n            |that return.\n            |")), schemaInfo).protoId(156);
            this.receiver = (EdgeType)builder.addEdgeType("RECEIVER", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Similar to `ARGUMENT` edges, `RECEIVER` edges connect call sites\n            |to their receiver arguments. A receiver argument is the object on\n            |which a method operates, that is, it is the expression that is\n            |assigned to the `this` pointer as control is transferred to the method.\n            |")), schemaInfo).protoId(55);
            this.dispatchTypes = builder.addConstants("DispatchTypes", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Constant[]{(Constant)Constant$.MODULE$.apply("STATIC_DISPATCH", "STATIC_DISPATCH", (Property.ValueType)Property.ValueType$.String$.MODULE$, "For statically dispatched calls the call target is known before program execution", schemaInfo).protoId(1), (Constant)Constant$.MODULE$.apply("DYNAMIC_DISPATCH", "DYNAMIC_DISPATCH", (Property.ValueType)Property.ValueType$.String$.MODULE$, "For dynamically dispatched calls the target is determined during runtime", schemaInfo).protoId(2), (Constant)Constant$.MODULE$.apply("INLINED", "INLINED", (Property.ValueType)Property.ValueType$.String$.MODULE$, "For macro expansions, code is inlined.", schemaInfo).protoId(3)}));
            astSchema.callNode().addProperties((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{this.dispatchType()}));
            astSchema.callNode().addOutEdge(this.call(), (AbstractNodeType)methodSchema.method(), astSchema.callNode().addOutEdge$default$3(), astSchema.callNode().addOutEdge$default$4(), astSchema.callNode().addOutEdge$default$5(), astSchema.callNode().addOutEdge$default$6(), astSchema.callNode().addOutEdge$default$7(), astSchema.callNode().addOutEdge$default$8());
            ((AbstractNodeType)astSchema.callNode().addProperty(this.methodFullName())).extendz((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NodeBaseType[]{astSchema.expression()}));
            astSchema.jumpTarget().addProperty(this.argumentIndex());
            astSchema.methodRef().addProperty(this.methodFullName());
            NodeType nodeType = (NodeType)astSchema.callNode().addOutEdge(this.receiver(), (AbstractNodeType)astSchema.callNode(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, astSchema.callNode().addOutEdge$default$5(), astSchema.callNode().addOutEdge$default$6(), astSchema.callNode().addOutEdge$default$7(), astSchema.callNode().addOutEdge$default$8());
            NodeType nodeType2 = (NodeType)nodeType.addOutEdge(this.receiver(), (AbstractNodeType)astSchema.identifier(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType.addOutEdge$default$5(), nodeType.addOutEdge$default$6(), nodeType.addOutEdge$default$7(), nodeType.addOutEdge$default$8());
            NodeType nodeType3 = (NodeType)nodeType2.addOutEdge(this.receiver(), (AbstractNodeType)astSchema.literal(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType2.addOutEdge$default$5(), nodeType2.addOutEdge$default$6(), nodeType2.addOutEdge$default$7(), nodeType2.addOutEdge$default$8());
            NodeType nodeType4 = (NodeType)nodeType3.addOutEdge(this.receiver(), (AbstractNodeType)astSchema.methodRef(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType3.addOutEdge$default$5(), nodeType3.addOutEdge$default$6(), nodeType3.addOutEdge$default$7(), nodeType3.addOutEdge$default$8());
            NodeType nodeType5 = (NodeType)nodeType4.addOutEdge(this.receiver(), (AbstractNodeType)astSchema.typeRef(), nodeType4.addOutEdge$default$3(), nodeType4.addOutEdge$default$4(), nodeType4.addOutEdge$default$5(), nodeType4.addOutEdge$default$6(), nodeType4.addOutEdge$default$7(), nodeType4.addOutEdge$default$8());
            NodeType nodeType6 = (NodeType)nodeType5.addOutEdge(this.receiver(), (AbstractNodeType)astSchema.block(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType5.addOutEdge$default$5(), nodeType5.addOutEdge$default$6(), nodeType5.addOutEdge$default$7(), nodeType5.addOutEdge$default$8());
            NodeType nodeType7 = (NodeType)nodeType6.addOutEdge(this.receiver(), (AbstractNodeType)astSchema.controlStructure(), nodeType6.addOutEdge$default$3(), nodeType6.addOutEdge$default$4(), nodeType6.addOutEdge$default$5(), nodeType6.addOutEdge$default$6(), nodeType6.addOutEdge$default$7(), nodeType6.addOutEdge$default$8());
            NodeType nodeType8 = (NodeType)nodeType7.addOutEdge(this.receiver(), (AbstractNodeType)astSchema.unknown(), nodeType7.addOutEdge$default$3(), nodeType7.addOutEdge$default$4(), nodeType7.addOutEdge$default$5(), nodeType7.addOutEdge$default$6(), nodeType7.addOutEdge$default$7(), nodeType7.addOutEdge$default$8());
            NodeType nodeType9 = (NodeType)nodeType8.addOutEdge(this.argument(), (AbstractNodeType)astSchema.callNode(), nodeType8.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType8.addOutEdge$default$5(), nodeType8.addOutEdge$default$6(), nodeType8.addOutEdge$default$7(), nodeType8.addOutEdge$default$8());
            NodeType nodeType10 = (NodeType)nodeType9.addOutEdge(this.argument(), (AbstractNodeType)astSchema.identifier(), nodeType9.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType9.addOutEdge$default$5(), nodeType9.addOutEdge$default$6(), nodeType9.addOutEdge$default$7(), nodeType9.addOutEdge$default$8());
            NodeType nodeType11 = (NodeType)nodeType10.addOutEdge(this.argument(), (AbstractNodeType)astSchema.fieldIdentifier(), nodeType10.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.One$.MODULE$, nodeType10.addOutEdge$default$5(), nodeType10.addOutEdge$default$6(), nodeType10.addOutEdge$default$7(), nodeType10.addOutEdge$default$8());
            NodeType nodeType12 = (NodeType)nodeType11.addOutEdge(this.argument(), (AbstractNodeType)astSchema.literal(), nodeType11.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType11.addOutEdge$default$5(), nodeType11.addOutEdge$default$6(), nodeType11.addOutEdge$default$7(), nodeType11.addOutEdge$default$8());
            NodeType nodeType13 = (NodeType)nodeType12.addOutEdge(this.argument(), (AbstractNodeType)astSchema.methodRef(), nodeType12.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType12.addOutEdge$default$5(), nodeType12.addOutEdge$default$6(), nodeType12.addOutEdge$default$7(), nodeType12.addOutEdge$default$8());
            NodeType nodeType14 = (NodeType)nodeType13.addOutEdge(this.argument(), (AbstractNodeType)astSchema.typeRef(), nodeType13.addOutEdge$default$3(), nodeType13.addOutEdge$default$4(), nodeType13.addOutEdge$default$5(), nodeType13.addOutEdge$default$6(), nodeType13.addOutEdge$default$7(), nodeType13.addOutEdge$default$8());
            NodeType nodeType15 = (NodeType)nodeType14.addOutEdge(this.argument(), (AbstractNodeType)astSchema.block(), nodeType14.addOutEdge$default$3(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType14.addOutEdge$default$5(), nodeType14.addOutEdge$default$6(), nodeType14.addOutEdge$default$7(), nodeType14.addOutEdge$default$8());
            NodeType nodeType16 = (NodeType)nodeType15.addOutEdge(this.argument(), (AbstractNodeType)astSchema.jumpTarget(), nodeType15.addOutEdge$default$3(), nodeType15.addOutEdge$default$4(), nodeType15.addOutEdge$default$5(), nodeType15.addOutEdge$default$6(), nodeType15.addOutEdge$default$7(), nodeType15.addOutEdge$default$8());
            NodeType nodeType17 = (NodeType)nodeType16.addOutEdge(this.argument(), (AbstractNodeType)astSchema.controlStructure(), nodeType16.addOutEdge$default$3(), nodeType16.addOutEdge$default$4(), nodeType16.addOutEdge$default$5(), nodeType16.addOutEdge$default$6(), nodeType16.addOutEdge$default$7(), nodeType16.addOutEdge$default$8());
            nodeType17.addOutEdge(this.argument(), (AbstractNodeType)astSchema.unknown(), nodeType17.addOutEdge$default$3(), nodeType17.addOutEdge$default$4(), nodeType17.addOutEdge$default$5(), nodeType17.addOutEdge$default$6(), nodeType17.addOutEdge$default$7(), nodeType17.addOutEdge$default$8());
            NodeType nodeType18 = (NodeType)astSchema.ret().addOutEdge(this.argument(), (AbstractNodeType)astSchema.callNode(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, astSchema.ret().addOutEdge$default$5(), astSchema.ret().addOutEdge$default$6(), astSchema.ret().addOutEdge$default$7(), astSchema.ret().addOutEdge$default$8());
            NodeType nodeType19 = (NodeType)nodeType18.addOutEdge(this.argument(), (AbstractNodeType)astSchema.identifier(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType18.addOutEdge$default$5(), nodeType18.addOutEdge$default$6(), nodeType18.addOutEdge$default$7(), nodeType18.addOutEdge$default$8());
            NodeType nodeType20 = (NodeType)nodeType19.addOutEdge(this.argument(), (AbstractNodeType)astSchema.literal(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType19.addOutEdge$default$5(), nodeType19.addOutEdge$default$6(), nodeType19.addOutEdge$default$7(), nodeType19.addOutEdge$default$8());
            NodeType nodeType21 = (NodeType)nodeType20.addOutEdge(this.argument(), (AbstractNodeType)astSchema.methodRef(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType20.addOutEdge$default$5(), nodeType20.addOutEdge$default$6(), nodeType20.addOutEdge$default$7(), nodeType20.addOutEdge$default$8());
            NodeType nodeType22 = (NodeType)nodeType21.addOutEdge(this.argument(), (AbstractNodeType)astSchema.typeRef(), nodeType21.addOutEdge$default$3(), nodeType21.addOutEdge$default$4(), nodeType21.addOutEdge$default$5(), nodeType21.addOutEdge$default$6(), nodeType21.addOutEdge$default$7(), nodeType21.addOutEdge$default$8());
            NodeType nodeType23 = (NodeType)nodeType22.addOutEdge(this.argument(), (AbstractNodeType)astSchema.ret(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType22.addOutEdge$default$5(), nodeType22.addOutEdge$default$6(), nodeType22.addOutEdge$default$7(), nodeType22.addOutEdge$default$8());
            NodeType nodeType24 = (NodeType)nodeType23.addOutEdge(this.argument(), (AbstractNodeType)astSchema.block(), (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, (EdgeType.Cardinality)EdgeType.Cardinality$.ZeroOrOne$.MODULE$, nodeType23.addOutEdge$default$5(), nodeType23.addOutEdge$default$6(), nodeType23.addOutEdge$default$7(), nodeType23.addOutEdge$default$8());
            NodeType nodeType25 = (NodeType)nodeType24.addOutEdge(this.argument(), (AbstractNodeType)astSchema.jumpTarget(), nodeType24.addOutEdge$default$3(), nodeType24.addOutEdge$default$4(), nodeType24.addOutEdge$default$5(), nodeType24.addOutEdge$default$6(), nodeType24.addOutEdge$default$7(), nodeType24.addOutEdge$default$8());
            NodeType nodeType26 = (NodeType)nodeType25.addOutEdge(this.argument(), (AbstractNodeType)astSchema.controlStructure(), nodeType25.addOutEdge$default$3(), nodeType25.addOutEdge$default$4(), nodeType25.addOutEdge$default$5(), nodeType25.addOutEdge$default$6(), nodeType25.addOutEdge$default$7(), nodeType25.addOutEdge$default$8());
            nodeType26.addOutEdge(this.argument(), (AbstractNodeType)astSchema.unknown(), nodeType26.addOutEdge$default$3(), nodeType26.addOutEdge$default$4(), nodeType26.addOutEdge$default$5(), nodeType26.addOutEdge$default$6(), nodeType26.addOutEdge$default$7(), nodeType26.addOutEdge$default$8());
        }

        public Property<Object> argumentIndex() {
            return this.argumentIndex;
        }

        public Property<String> argumentName() {
            return this.argumentName;
        }

        public Property<String> methodFullName() {
            return this.methodFullName;
        }

        public Property<String> evaluationStrategy() {
            return this.evaluationStrategy;
        }

        public Seq<Constant<?>> evaluationStrategies() {
            return this.evaluationStrategies;
        }

        public Property<String> dispatchType() {
            return this.dispatchType;
        }

        public EdgeType call() {
            return this.call;
        }

        public EdgeType argument() {
            return this.argument;
        }

        public EdgeType receiver() {
            return this.receiver;
        }

        public Seq<Constant<?>> dispatchTypes() {
            return this.dispatchTypes;
        }
    }
}

