/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.cpgloading;

import io.shiftleft.codepropertygraph.Cpg;
import io.shiftleft.codepropertygraph.cpgloading.ProtoToCpg;
import io.shiftleft.codepropertygraph.cpgloading.ZipArchive;
import io.shiftleft.overflowdb.OdbConfig;
import io.shiftleft.proto.cpg.Cpg;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import resource.ManagedResource;
import resource.Resource$;
import resource.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ProtoCpgLoader$ {
    public static ProtoCpgLoader$ MODULE$;
    private final Logger logger;

    static {
        new ProtoCpgLoader$();
    }

    private Logger logger() {
        return this.logger;
    }

    public Cpg loadFromProtoZip(String fileName, OdbConfig overflowDbConfig) {
        return (Cpg)this.measureAndReport((Function0 & Serializable & scala.Serializable)() -> {
            ProtoToCpg builder = new ProtoToCpg(overflowDbConfig);
            package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new ZipArchive(fileName), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(ZipArchive.class)).foreach((Function1 & Serializable & scala.Serializable)zip -> {
                ProtoCpgLoader$.$anonfun$loadFromProtoZip$3(builder, zip);
                return BoxedUnit.UNIT;
            });
            package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new ZipArchive(fileName), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(ZipArchive.class)).foreach((Function1 & Serializable & scala.Serializable)zip -> {
                ProtoCpgLoader$.$anonfun$loadFromProtoZip$8(builder, zip);
                return BoxedUnit.UNIT;
            });
            return builder.build();
        });
    }

    public OdbConfig loadFromProtoZip$default$2() {
        return OdbConfig.withoutOverflow();
    }

    public Cpg loadFromListOfProtos(Seq<Cpg.CpgStruct> cpgs, OdbConfig overflowDbConfig) {
        ProtoToCpg builder = new ProtoToCpg(overflowDbConfig);
        cpgs.foreach((Function1 & Serializable & scala.Serializable)cpg -> {
            builder.addNodes(cpg.getNodeList());
            return BoxedUnit.UNIT;
        });
        cpgs.foreach((Function1 & Serializable & scala.Serializable)cpg -> {
            builder.addEdges(cpg.getEdgeList());
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public Cpg loadFromListOfProtos(List<Cpg.CpgStruct> cpgs, OdbConfig overflowDbConfig) {
        return this.loadFromListOfProtos((Seq<Cpg.CpgStruct>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(cpgs).asScala()), overflowDbConfig);
    }

    public ManagedResource<Iterator<Cpg.CpgOverlay>> loadOverlays(String fileName) {
        return package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> new ZipArchive(fileName), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(ZipArchive.class)).map((Function1 & Serializable & scala.Serializable)zip -> MODULE$.readOverlayEntries((ZipArchive)zip));
    }

    private Cpg.CpgOverlay readOverlay(Path path) {
        return (Cpg.CpgOverlay)package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(path, new OpenOption[0]), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(InputStream.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> Cpg.CpgOverlay.parseFrom((InputStream)x$1)).tried().get();
    }

    private Iterator<Cpg.CpgOverlay> readOverlayEntries(ZipArchive zip) {
        return ((IterableLike)zip.entries().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ProtoCpgLoader$.MODULE$.compareOverlayPath(a, b)))).iterator().map((Function1 & Serializable & scala.Serializable)path -> MODULE$.readOverlay((Path)path));
    }

    private boolean compareOverlayPath(Path a, Path b) {
        String[] file1Split = ((Object)a).toString().replace("/", "").split("_");
        String[] file2Split = ((Object)b).toString().replace("/", "").split("_");
        return file1Split.length < 2 || file2Split.length < 2 ? new StringOps(Predef$.MODULE$.augmentString(((Object)a).toString())).$less((Object)((Object)b).toString()) : new StringOps(Predef$.MODULE$.augmentString(file1Split[0])).toInt() < new StringOps(Predef$.MODULE$.augmentString(file2Split[0])).toInt();
    }

    private Cpg.CpgStruct getNextProtoCpgFromStream(InputStream inputStream) {
        return Cpg.CpgStruct.parseFrom((InputStream)inputStream);
    }

    private <A> A measureAndReport(Function0<A> f) {
        long start = System.currentTimeMillis();
        Object result = f.apply();
        this.logger().info(new StringBuilder(32).append("CPG construction finished in ").append(System.currentTimeMillis() - start).append("ms.").toString());
        return (A)result;
    }

    public static final /* synthetic */ void $anonfun$loadFromProtoZip$4(ProtoToCpg builder$1, Path entry) {
        package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(entry, new OpenOption[0]), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(InputStream.class)).foreach((Function1 & Serializable & scala.Serializable)inputStream -> {
            builder$1.addNodes(ProtoCpgLoader$.MODULE$.getNextProtoCpgFromStream(inputStream).getNodeList());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$loadFromProtoZip$3(ProtoToCpg builder$1, ZipArchive zip) {
        zip.entries().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ProtoCpgLoader$.$anonfun$loadFromProtoZip$4(builder$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$loadFromProtoZip$9(ProtoToCpg builder$1, Path entry) {
        package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(entry, new OpenOption[0]), Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(InputStream.class)).foreach((Function1 & Serializable & scala.Serializable)inputStream -> {
            builder$1.addEdges(ProtoCpgLoader$.MODULE$.getNextProtoCpgFromStream(inputStream).getEdgeList());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$loadFromProtoZip$8(ProtoToCpg builder$1, ZipArchive zip) {
        zip.entries().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ProtoCpgLoader$.$anonfun$loadFromProtoZip$9(builder$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    private ProtoCpgLoader$() {
        MODULE$ = this;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

