package io.shiftleft.codepropertygraph.generated.edges

import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Set => JSet}
import java.util.{List => JList}
import org.apache.tinkerpop.gremlin.structure.Property
import org.apache.tinkerpop.gremlin.structure.{Vertex, VertexProperty}
import overflowdb.{EdgeLayoutInformation, EdgeFactory, NodeFactory, OdbEdge, OdbNode, OdbGraph, NodeRef}
import scala.jdk.CollectionConverters._

object PropertyErrorRegister {
  private var errorMap = Set[(Class[_], String)]()
  private val logger = org.slf4j.LoggerFactory.getLogger(getClass)

  def logPropertyErrorIfFirst(clazz: Class[_], propertyName: String): Unit = {
    if (!errorMap.contains((clazz, propertyName))) {
      logger.warn("Property " + propertyName + " is deprecated for " + clazz.getName + ".")
      errorMap += ((clazz, propertyName))
    }
  }
}

object Factories {
  lazy val all: List[EdgeFactory[_]] = List(Binds.factory, TaintRemove.factory, EvalType.factory, CapturedBy.factory, PostDominate.factory, IsSensitiveDataOfType.factory, Propagate.factory, IsSensitiveDataDescrOfRef.factory, Condition.factory, Receiver.factory, Capture.factory, AttachedData.factory, Argument.factory, TaggedBy.factory, AliasOf.factory, Cdg.factory, ContainsNode.factory, ParameterLink.factory, Ast.factory, Ref.factory, Contains.factory, DynamicType.factory, IsSensitiveDataDescrOf.factory, SourceFile.factory, BindsTo.factory, Vtable.factory, InheritsFrom.factory, ReachingDef.factory, Dominate.factory, Cfg.factory, Call.factory)
  lazy val allAsJava: java.util.List[EdgeFactory[_]] = all.asJava
}

